/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.support;

import org.springframework.util.Assert;
import org.springframework.web.reactive.HandlerResult;
import org.springframework.web.reactive.HandlerResultHandler;
import org.springframework.web.reactive.function.HandlerStrategies;
import org.springframework.web.reactive.function.ServerResponse;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class ServerResponseResultHandler
implements HandlerResultHandler {
    private final HandlerStrategies strategies;

    public ServerResponseResultHandler() {
        this(HandlerStrategies.builder().build());
    }

    public ServerResponseResultHandler(HandlerStrategies strategies) {
        Assert.notNull((Object)strategies, (String)"'strategies' must not be null");
        this.strategies = strategies;
    }

    @Override
    public boolean supports(HandlerResult result) {
        return result.getReturnValue().filter(o -> o instanceof ServerResponse).isPresent();
    }

    @Override
    public Mono<Void> handleResult(ServerWebExchange exchange, HandlerResult result) {
        ServerResponse response = (ServerResponse)result.getReturnValue().orElseThrow(IllegalStateException::new);
        return response.writeTo(exchange, this.strategies);
    }
}

