/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.support;

import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRange;
import org.springframework.http.MediaType;
import org.springframework.http.codec.BodyExtractor;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.Assert;
import org.springframework.web.reactive.function.ServerRequest;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ServerRequestWrapper
implements ServerRequest {
    private final ServerRequest request;

    public ServerRequestWrapper(ServerRequest request) {
        Assert.notNull((Object)request, (String)"'request' must not be null");
        this.request = request;
    }

    public ServerRequest request() {
        return this.request;
    }

    @Override
    public HttpMethod method() {
        return this.request.method();
    }

    @Override
    public URI uri() {
        return this.request.uri();
    }

    @Override
    public String path() {
        return this.request.path();
    }

    @Override
    public ServerRequest.Headers headers() {
        return this.request.headers();
    }

    @Override
    public <T> T body(BodyExtractor<T, ? super ServerHttpRequest> extractor) {
        return this.request.body(extractor);
    }

    @Override
    public <T> Mono<T> bodyToMono(Class<? extends T> elementClass) {
        return this.request.bodyToMono(elementClass);
    }

    @Override
    public <T> Flux<T> bodyToFlux(Class<? extends T> elementClass) {
        return this.request.bodyToFlux(elementClass);
    }

    @Override
    public <T> Optional<T> attribute(String name) {
        return this.request.attribute(name);
    }

    @Override
    public Optional<String> queryParam(String name) {
        return this.request.queryParam(name);
    }

    @Override
    public List<String> queryParams(String name) {
        return this.request.queryParams(name);
    }

    @Override
    public String pathVariable(String name) {
        return this.request.pathVariable(name);
    }

    @Override
    public Map<String, String> pathVariables() {
        return this.request.pathVariables();
    }

    public static class HeadersWrapper
    implements ServerRequest.Headers {
        private final ServerRequest.Headers headers;

        public HeadersWrapper(ServerRequest.Headers headers) {
            Assert.notNull((Object)headers, (String)"'headers' must not be null");
            this.headers = headers;
        }

        @Override
        public List<MediaType> accept() {
            return this.headers.accept();
        }

        @Override
        public List<Charset> acceptCharset() {
            return this.headers.acceptCharset();
        }

        @Override
        public OptionalLong contentLength() {
            return this.headers.contentLength();
        }

        @Override
        public Optional<MediaType> contentType() {
            return this.headers.contentType();
        }

        @Override
        public InetSocketAddress host() {
            return this.headers.host();
        }

        @Override
        public List<HttpRange> range() {
            return this.headers.range();
        }

        @Override
        public List<String> header(String headerName) {
            return this.headers.header(headerName);
        }

        @Override
        public HttpHeaders asHttpHeaders() {
            return this.headers.asHttpHeaders();
        }
    }
}

