/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.support;

import java.lang.reflect.Method;
import org.springframework.core.MethodParameter;
import org.springframework.web.reactive.HandlerAdapter;
import org.springframework.web.reactive.HandlerResult;
import org.springframework.web.reactive.function.HandlerFunction;
import org.springframework.web.reactive.function.RouterFunctions;
import org.springframework.web.reactive.function.ServerRequest;
import org.springframework.web.reactive.function.ServerResponse;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class HandlerFunctionAdapter
implements HandlerAdapter {
    private static final MethodParameter HANDLER_FUNCTION_RETURN_TYPE;

    @Override
    public boolean supports(Object handler) {
        return handler instanceof HandlerFunction;
    }

    @Override
    public Mono<HandlerResult> handle(ServerWebExchange exchange, Object handler) {
        HandlerFunction handlerFunction = (HandlerFunction)handler;
        ServerRequest request = (ServerRequest)exchange.getAttribute(RouterFunctions.REQUEST_ATTRIBUTE).orElseThrow(() -> new IllegalStateException("Could not find ServerRequest in exchange attributes"));
        ServerResponse response = handlerFunction.handle(request);
        HandlerResult handlerResult = new HandlerResult(handlerFunction, response, HANDLER_FUNCTION_RETURN_TYPE);
        return Mono.just((Object)handlerResult);
    }

    static {
        try {
            Method method = HandlerFunction.class.getMethod("handle", ServerRequest.class);
            HANDLER_FUNCTION_RETURN_TYPE = new MethodParameter(method, -1);
        }
        catch (NoSuchMethodException ex) {
            throw new Error(ex);
        }
    }
}

