/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function;

import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRange;
import org.springframework.http.MediaType;
import org.springframework.http.codec.BodyExtractor;
import org.springframework.http.server.reactive.ServerHttpRequest;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface ServerRequest {
    public HttpMethod method();

    public URI uri();

    default public String path() {
        return this.uri().getPath();
    }

    public Headers headers();

    public <T> T body(BodyExtractor<T, ? super ServerHttpRequest> var1);

    public <T> Mono<T> bodyToMono(Class<? extends T> var1);

    public <T> Flux<T> bodyToFlux(Class<? extends T> var1);

    public <T> Optional<T> attribute(String var1);

    default public Optional<String> queryParam(String name) {
        List<String> queryParams = this.queryParams(name);
        return !queryParams.isEmpty() ? Optional.of(queryParams.get(0)) : Optional.empty();
    }

    public List<String> queryParams(String var1);

    default public String pathVariable(String name) {
        Map<String, String> pathVariables = this.pathVariables();
        if (pathVariables.containsKey(name)) {
            return this.pathVariables().get(name);
        }
        throw new IllegalArgumentException("No path variable with name \"" + name + "\" available");
    }

    public Map<String, String> pathVariables();

    public static interface Headers {
        public List<MediaType> accept();

        public List<Charset> acceptCharset();

        public OptionalLong contentLength();

        public Optional<MediaType> contentType();

        public InetSocketAddress host();

        public List<HttpRange> range();

        public List<String> header(String var1);

        public HttpHeaders asHttpHeaders();
    }
}

