/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function;

import java.util.Map;
import java.util.Optional;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.util.Assert;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.reactive.function.DefaultServerRequest;
import org.springframework.web.reactive.function.HandlerFunction;
import org.springframework.web.reactive.function.HandlerStrategies;
import org.springframework.web.reactive.function.RequestPredicate;
import org.springframework.web.reactive.function.RouterFunction;
import org.springframework.web.reactive.function.ServerRequest;
import org.springframework.web.reactive.function.ServerResponse;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.adapter.HttpWebHandlerAdapter;
import reactor.core.publisher.Mono;

public abstract class RouterFunctions {
    public static final String REQUEST_ATTRIBUTE = RouterFunctions.class.getName() + ".request";
    public static final String URI_TEMPLATE_VARIABLES_ATTRIBUTE = RouterFunctions.class.getName() + ".uriTemplateVariables";
    private static final HandlerFunction<Void> NOT_FOUND_HANDLER = request -> ServerResponse.notFound().build();

    public static <T> RouterFunction<T> route(RequestPredicate predicate, HandlerFunction<T> handlerFunction) {
        Assert.notNull((Object)predicate, (String)"'predicate' must not be null");
        Assert.notNull(handlerFunction, (String)"'handlerFunction' must not be null");
        return request -> predicate.test(request) ? Optional.of(handlerFunction) : Optional.empty();
    }

    public static <T> RouterFunction<T> subroute(RequestPredicate predicate, RouterFunction<T> routerFunction) {
        Assert.notNull((Object)predicate, (String)"'predicate' must not be null");
        Assert.notNull(routerFunction, (String)"'routerFunction' must not be null");
        return request -> {
            if (predicate.test(request)) {
                ServerRequest subRequest = predicate.subRequest(request);
                return routerFunction.route(subRequest);
            }
            return Optional.empty();
        };
    }

    public static HttpHandler toHttpHandler(RouterFunction<?> routerFunction) {
        return RouterFunctions.toHttpHandler(routerFunction, HandlerStrategies.withDefaults());
    }

    public static HttpHandler toHttpHandler(RouterFunction<?> routerFunction, HandlerStrategies strategies) {
        Assert.notNull(routerFunction, (String)"RouterFunction must not be null");
        Assert.notNull((Object)strategies, (String)"HandlerStrategies must not be null");
        return new HttpWebHandlerAdapter(exchange -> {
            DefaultServerRequest request = new DefaultServerRequest(exchange, strategies);
            RouterFunctions.addAttributes(exchange, request);
            HandlerFunction handlerFunction = routerFunction.route(request).orElse(RouterFunctions.notFound());
            ServerResponse response = handlerFunction.handle(request);
            return response.writeTo(exchange, strategies);
        });
    }

    public static HandlerMapping toHandlerMapping(RouterFunction<?> routerFunction) {
        return RouterFunctions.toHandlerMapping(routerFunction, HandlerStrategies.withDefaults());
    }

    public static HandlerMapping toHandlerMapping(RouterFunction<?> routerFunction, HandlerStrategies strategies) {
        Assert.notNull(routerFunction, (String)"RouterFunction must not be null");
        Assert.notNull((Object)strategies, (String)"HandlerStrategies must not be null");
        return exchange -> {
            DefaultServerRequest request = new DefaultServerRequest(exchange, strategies);
            RouterFunctions.addAttributes(exchange, request);
            Optional route = routerFunction.route(request);
            return Mono.justOrEmpty(route);
        };
    }

    private static void addAttributes(ServerWebExchange exchange, ServerRequest request) {
        Map attributes = exchange.getAttributes();
        attributes.put(REQUEST_ATTRIBUTE, request);
    }

    private static <T> HandlerFunction<T> notFound() {
        return NOT_FOUND_HANDLER;
    }

    static <T> HandlerFunction<T> cast(HandlerFunction<?> handlerFunction) {
        return handlerFunction;
    }
}

