/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function;

import java.util.Optional;
import org.springframework.web.reactive.function.HandlerFilterFunction;
import org.springframework.web.reactive.function.HandlerFunction;
import org.springframework.web.reactive.function.RequestPredicate;
import org.springframework.web.reactive.function.RouterFunctions;
import org.springframework.web.reactive.function.ServerRequest;

@FunctionalInterface
public interface RouterFunction<T> {
    public Optional<HandlerFunction<T>> route(ServerRequest var1);

    default public RouterFunction<T> andSame(RouterFunction<T> other) {
        return request -> {
            Optional<HandlerFunction<HandlerFunction<T>>> result = this.route(request);
            return result.isPresent() ? result : other.route(request);
        };
    }

    default public RouterFunction<?> and(RouterFunction<?> other) {
        return request -> {
            Optional<HandlerFunction> result = this.route(request).map(RouterFunctions::cast);
            return result.isPresent() ? result : other.route(request).map(RouterFunctions::cast);
        };
    }

    default public RouterFunction<?> andRoute(RequestPredicate predicate, HandlerFunction<?> handlerFunction) {
        return this.and(RouterFunctions.route(predicate, handlerFunction));
    }

    default public <S> RouterFunction<S> filter(HandlerFilterFunction<T, S> filterFunction) {
        return request -> this.route(request).map(filterFunction::apply);
    }
}

