/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function;

import org.springframework.util.Assert;
import org.springframework.web.reactive.function.HandlerFunction;
import org.springframework.web.reactive.function.ServerRequest;
import org.springframework.web.reactive.function.ServerResponse;

@FunctionalInterface
public interface HandlerFilterFunction<T, R> {
    public ServerResponse<R> filter(ServerRequest var1, HandlerFunction<T> var2);

    default public HandlerFilterFunction<T, R> andThen(HandlerFilterFunction<T, T> after) {
        Assert.notNull(after, (String)"'after' must not be null");
        return (request, next) -> {
            HandlerFunction nextHandler = handlerRequest -> after.filter(handlerRequest, next);
            return this.filter(request, nextHandler);
        };
    }

    default public HandlerFunction<R> apply(HandlerFunction<T> handler) {
        Assert.notNull(handler, (String)"'handler' must not be null");
        return request -> this.filter(request, handler);
    }
}

