/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.core.codec.ByteArrayDecoder;
import org.springframework.core.codec.ByteArrayEncoder;
import org.springframework.core.codec.ByteBufferDecoder;
import org.springframework.core.codec.ByteBufferEncoder;
import org.springframework.core.codec.CharSequenceEncoder;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.Encoder;
import org.springframework.core.codec.ResourceDecoder;
import org.springframework.core.codec.StringDecoder;
import org.springframework.core.convert.ConversionService;
import org.springframework.format.FormatterRegistry;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.format.support.FormattingConversionService;
import org.springframework.http.MediaType;
import org.springframework.http.codec.DecoderHttpMessageReader;
import org.springframework.http.codec.EncoderHttpMessageWriter;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.http.codec.Jackson2ServerHttpMessageReader;
import org.springframework.http.codec.Jackson2ServerHttpMessageWriter;
import org.springframework.http.codec.ResourceHttpMessageWriter;
import org.springframework.http.codec.ServerSentEventHttpMessageWriter;
import org.springframework.http.codec.json.Jackson2JsonDecoder;
import org.springframework.http.codec.json.Jackson2JsonEncoder;
import org.springframework.http.codec.xml.Jaxb2XmlDecoder;
import org.springframework.http.codec.xml.Jaxb2XmlEncoder;
import org.springframework.util.ClassUtils;
import org.springframework.validation.Errors;
import org.springframework.validation.MessageCodesResolver;
import org.springframework.validation.Validator;
import org.springframework.web.bind.support.ConfigurableWebBindingInitializer;
import org.springframework.web.bind.support.WebBindingInitializer;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.reactive.DispatcherHandler;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.reactive.accept.CompositeContentTypeResolver;
import org.springframework.web.reactive.accept.RequestedContentTypeResolverBuilder;
import org.springframework.web.reactive.config.CorsRegistry;
import org.springframework.web.reactive.config.PathMatchConfigurer;
import org.springframework.web.reactive.config.ResourceHandlerRegistry;
import org.springframework.web.reactive.config.ViewResolverRegistry;
import org.springframework.web.reactive.handler.AbstractHandlerMapping;
import org.springframework.web.reactive.result.SimpleHandlerAdapter;
import org.springframework.web.reactive.result.method.HandlerMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.reactive.result.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.reactive.result.method.annotation.ResponseBodyResultHandler;
import org.springframework.web.reactive.result.method.annotation.ResponseEntityResultHandler;
import org.springframework.web.reactive.result.view.ViewResolutionResultHandler;
import org.springframework.web.reactive.result.view.ViewResolver;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebExceptionHandler;
import org.springframework.web.server.handler.ResponseStatusExceptionHandler;
import reactor.core.publisher.Mono;

public class WebReactiveConfigurationSupport
implements ApplicationContextAware {
    private static final boolean jackson2Present = ClassUtils.isPresent((String)"com.fasterxml.jackson.databind.ObjectMapper", (ClassLoader)WebReactiveConfigurationSupport.class.getClassLoader()) && ClassUtils.isPresent((String)"com.fasterxml.jackson.core.JsonGenerator", (ClassLoader)WebReactiveConfigurationSupport.class.getClassLoader());
    private static final boolean jaxb2Present = ClassUtils.isPresent((String)"javax.xml.bind.Binder", (ClassLoader)WebReactiveConfigurationSupport.class.getClassLoader());
    private Map<String, CorsConfiguration> corsConfigurations;
    private PathMatchConfigurer pathMatchConfigurer;
    private List<HttpMessageReader<?>> messageReaders;
    private List<HttpMessageWriter<?>> messageWriters;
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    protected ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Bean
    public DispatcherHandler webHandler() {
        return new DispatcherHandler();
    }

    @Bean
    public WebExceptionHandler responseStatusExceptionHandler() {
        return new ResponseStatusExceptionHandler();
    }

    @Bean
    public RequestMappingHandlerMapping requestMappingHandlerMapping() {
        RequestMappingHandlerMapping mapping = this.createRequestMappingHandlerMapping();
        mapping.setOrder(0);
        mapping.setContentTypeResolver(this.webReactiveContentTypeResolver());
        mapping.setCorsConfigurations(this.getCorsConfigurations());
        PathMatchConfigurer configurer = this.getPathMatchConfigurer();
        if (configurer.isUseSuffixPatternMatch() != null) {
            mapping.setUseSuffixPatternMatch(configurer.isUseSuffixPatternMatch());
        }
        if (configurer.isUseRegisteredSuffixPatternMatch() != null) {
            mapping.setUseRegisteredSuffixPatternMatch(configurer.isUseRegisteredSuffixPatternMatch());
        }
        if (configurer.isUseTrailingSlashMatch() != null) {
            mapping.setUseTrailingSlashMatch(configurer.isUseTrailingSlashMatch());
        }
        if (configurer.getPathMatcher() != null) {
            mapping.setPathMatcher(configurer.getPathMatcher());
        }
        if (configurer.getPathHelper() != null) {
            mapping.setPathHelper(configurer.getPathHelper());
        }
        return mapping;
    }

    protected RequestMappingHandlerMapping createRequestMappingHandlerMapping() {
        return new RequestMappingHandlerMapping();
    }

    @Bean
    public CompositeContentTypeResolver webReactiveContentTypeResolver() {
        RequestedContentTypeResolverBuilder builder = new RequestedContentTypeResolverBuilder();
        builder.mediaTypes(this.getDefaultMediaTypeMappings());
        this.configureContentTypeResolver(builder);
        return builder.build();
    }

    protected Map<String, MediaType> getDefaultMediaTypeMappings() {
        HashMap<String, MediaType> map = new HashMap<String, MediaType>();
        if (jackson2Present) {
            map.put("json", MediaType.APPLICATION_JSON);
        }
        return map;
    }

    protected void configureContentTypeResolver(RequestedContentTypeResolverBuilder builder) {
    }

    protected final Map<String, CorsConfiguration> getCorsConfigurations() {
        if (this.corsConfigurations == null) {
            CorsRegistry registry = new CorsRegistry();
            this.addCorsMappings(registry);
            this.corsConfigurations = registry.getCorsConfigurations();
        }
        return this.corsConfigurations;
    }

    protected void addCorsMappings(CorsRegistry registry) {
    }

    protected final PathMatchConfigurer getPathMatchConfigurer() {
        if (this.pathMatchConfigurer == null) {
            this.pathMatchConfigurer = new PathMatchConfigurer();
            this.configurePathMatching(this.pathMatchConfigurer);
        }
        return this.pathMatchConfigurer;
    }

    public void configurePathMatching(PathMatchConfigurer configurer) {
    }

    @Bean
    public HandlerMapping resourceHandlerMapping() {
        ResourceHandlerRegistry registry = new ResourceHandlerRegistry(this.applicationContext, this.webReactiveContentTypeResolver());
        this.addResourceHandlers(registry);
        AbstractHandlerMapping handlerMapping = registry.getHandlerMapping();
        if (handlerMapping != null) {
            PathMatchConfigurer pathMatchConfigurer = this.getPathMatchConfigurer();
            if (pathMatchConfigurer.getPathMatcher() != null) {
                handlerMapping.setPathMatcher(pathMatchConfigurer.getPathMatcher());
            }
            if (pathMatchConfigurer.getPathHelper() != null) {
                handlerMapping.setPathHelper(pathMatchConfigurer.getPathHelper());
            }
        } else {
            handlerMapping = new EmptyHandlerMapping();
        }
        return handlerMapping;
    }

    protected void addResourceHandlers(ResourceHandlerRegistry registry) {
    }

    @Bean
    public RequestMappingHandlerAdapter requestMappingHandlerAdapter() {
        RequestMappingHandlerAdapter adapter = this.createRequestMappingHandlerAdapter();
        adapter.setMessageReaders(this.getMessageReaders());
        adapter.setWebBindingInitializer((WebBindingInitializer)this.getConfigurableWebBindingInitializer());
        ArrayList<HandlerMethodArgumentResolver> resolvers = new ArrayList<HandlerMethodArgumentResolver>();
        this.addArgumentResolvers(resolvers);
        if (!resolvers.isEmpty()) {
            adapter.setCustomArgumentResolvers(resolvers);
        }
        return adapter;
    }

    protected RequestMappingHandlerAdapter createRequestMappingHandlerAdapter() {
        return new RequestMappingHandlerAdapter();
    }

    protected void addArgumentResolvers(List<HandlerMethodArgumentResolver> resolvers) {
    }

    protected final List<HttpMessageReader<?>> getMessageReaders() {
        if (this.messageReaders == null) {
            this.messageReaders = new ArrayList();
            this.configureMessageReaders(this.messageReaders);
            if (this.messageReaders.isEmpty()) {
                this.addDefaultHttpMessageReaders(this.messageReaders);
            }
            this.extendMessageReaders(this.messageReaders);
        }
        return this.messageReaders;
    }

    protected void configureMessageReaders(List<HttpMessageReader<?>> messageReaders) {
    }

    protected final void addDefaultHttpMessageReaders(List<HttpMessageReader<?>> readers) {
        readers.add((HttpMessageReader<?>)new DecoderHttpMessageReader((Decoder)new ByteArrayDecoder()));
        readers.add((HttpMessageReader<?>)new DecoderHttpMessageReader((Decoder)new ByteBufferDecoder()));
        readers.add((HttpMessageReader<?>)new DecoderHttpMessageReader((Decoder)new StringDecoder()));
        readers.add((HttpMessageReader<?>)new DecoderHttpMessageReader((Decoder)new ResourceDecoder()));
        if (jaxb2Present) {
            readers.add((HttpMessageReader<?>)new DecoderHttpMessageReader((Decoder)new Jaxb2XmlDecoder()));
        }
        if (jackson2Present) {
            readers.add((HttpMessageReader<?>)new Jackson2ServerHttpMessageReader((HttpMessageReader)new DecoderHttpMessageReader((Decoder)new Jackson2JsonDecoder())));
        }
    }

    protected void extendMessageReaders(List<HttpMessageReader<?>> messageReaders) {
    }

    protected ConfigurableWebBindingInitializer getConfigurableWebBindingInitializer() {
        ConfigurableWebBindingInitializer initializer = new ConfigurableWebBindingInitializer();
        initializer.setConversionService((ConversionService)this.webReactiveConversionService());
        initializer.setValidator(this.webReactiveValidator());
        initializer.setMessageCodesResolver(this.getMessageCodesResolver());
        return initializer;
    }

    @Bean
    public FormattingConversionService webReactiveConversionService() {
        DefaultFormattingConversionService service = new DefaultFormattingConversionService();
        this.addFormatters((FormatterRegistry)service);
        return service;
    }

    protected void addFormatters(FormatterRegistry registry) {
    }

    @Bean
    public Validator webReactiveValidator() {
        Validator validator = this.getValidator();
        if (validator == null) {
            if (ClassUtils.isPresent((String)"javax.validation.Validator", (ClassLoader)this.getClass().getClassLoader())) {
                Class clazz;
                try {
                    String name = "org.springframework.validation.beanvalidation.OptionalValidatorFactoryBean";
                    clazz = ClassUtils.forName((String)name, (ClassLoader)this.getClass().getClassLoader());
                }
                catch (ClassNotFoundException ex) {
                    throw new BeanInitializationException("Could not find default validator class", (Throwable)ex);
                }
                catch (LinkageError ex) {
                    throw new BeanInitializationException("Could not load default validator class", (Throwable)ex);
                }
                validator = (Validator)BeanUtils.instantiateClass((Class)clazz);
            } else {
                validator = new NoOpValidator();
            }
        }
        return validator;
    }

    protected Validator getValidator() {
        return null;
    }

    protected MessageCodesResolver getMessageCodesResolver() {
        return null;
    }

    @Bean
    public SimpleHandlerAdapter simpleHandlerAdapter() {
        return new SimpleHandlerAdapter();
    }

    @Bean
    public ResponseEntityResultHandler responseEntityResultHandler() {
        return new ResponseEntityResultHandler(this.getMessageWriters(), this.webReactiveContentTypeResolver());
    }

    @Bean
    public ResponseBodyResultHandler responseBodyResultHandler() {
        return new ResponseBodyResultHandler(this.getMessageWriters(), this.webReactiveContentTypeResolver());
    }

    protected final List<HttpMessageWriter<?>> getMessageWriters() {
        if (this.messageWriters == null) {
            this.messageWriters = new ArrayList();
            this.configureMessageWriters(this.messageWriters);
            if (this.messageWriters.isEmpty()) {
                this.addDefaultHttpMessageWriters(this.messageWriters);
            }
            this.extendMessageWriters(this.messageWriters);
        }
        return this.messageWriters;
    }

    protected void configureMessageWriters(List<HttpMessageWriter<?>> messageWriters) {
    }

    protected final void addDefaultHttpMessageWriters(List<HttpMessageWriter<?>> writers) {
        ArrayList<Jackson2JsonEncoder> sseDataEncoders = new ArrayList<Jackson2JsonEncoder>();
        writers.add((HttpMessageWriter<?>)new EncoderHttpMessageWriter((Encoder)new ByteArrayEncoder()));
        writers.add((HttpMessageWriter<?>)new EncoderHttpMessageWriter((Encoder)new ByteBufferEncoder()));
        writers.add((HttpMessageWriter<?>)new EncoderHttpMessageWriter((Encoder)new CharSequenceEncoder()));
        writers.add((HttpMessageWriter<?>)new ResourceHttpMessageWriter());
        if (jaxb2Present) {
            writers.add((HttpMessageWriter<?>)new EncoderHttpMessageWriter((Encoder)new Jaxb2XmlEncoder()));
        }
        if (jackson2Present) {
            Jackson2JsonEncoder encoder = new Jackson2JsonEncoder();
            writers.add((HttpMessageWriter<?>)new Jackson2ServerHttpMessageWriter((Encoder)encoder));
            sseDataEncoders.add(encoder);
            ServerSentEventHttpMessageWriter writer = new ServerSentEventHttpMessageWriter(sseDataEncoders);
            writers.add((HttpMessageWriter<?>)new Jackson2ServerHttpMessageWriter((HttpMessageWriter)writer));
        } else {
            writers.add((HttpMessageWriter<?>)new ServerSentEventHttpMessageWriter(sseDataEncoders));
        }
    }

    protected void extendMessageWriters(List<HttpMessageWriter<?>> messageWriters) {
    }

    @Bean
    public ViewResolutionResultHandler viewResolutionResultHandler() {
        ViewResolverRegistry registry = new ViewResolverRegistry(this.getApplicationContext());
        this.configureViewResolvers(registry);
        List<ViewResolver> resolvers = registry.getViewResolvers();
        ViewResolutionResultHandler handler = new ViewResolutionResultHandler(resolvers, this.webReactiveContentTypeResolver());
        handler.setDefaultViews(registry.getDefaultViews());
        handler.setOrder(registry.getOrder());
        return handler;
    }

    protected void configureViewResolvers(ViewResolverRegistry registry) {
    }

    private static final class NoOpValidator
    implements Validator {
        private NoOpValidator() {
        }

        public boolean supports(Class<?> clazz) {
            return false;
        }

        public void validate(Object target, Errors errors) {
        }
    }

    private static final class EmptyHandlerMapping
    extends AbstractHandlerMapping {
        private EmptyHandlerMapping() {
        }

        public Mono<Object> getHandlerInternal(ServerWebExchange exchange) {
            return Mono.empty();
        }
    }
}

