/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.view;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.reactivestreams.Publisher;
import org.springframework.beans.BeanUtils;
import org.springframework.core.Conventions;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.MethodParameter;
import org.springframework.core.Ordered;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.http.MediaType;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.reactive.HandlerResult;
import org.springframework.web.reactive.HandlerResultHandler;
import org.springframework.web.reactive.accept.RequestedContentTypeResolver;
import org.springframework.web.reactive.result.ContentNegotiatingResultHandlerSupport;
import org.springframework.web.reactive.result.view.View;
import org.springframework.web.reactive.result.view.ViewResolver;
import org.springframework.web.server.NotAcceptableStatusException;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.HttpRequestPathHelper;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ViewResolutionResultHandler
extends ContentNegotiatingResultHandlerSupport
implements HandlerResultHandler,
Ordered {
    private final List<ViewResolver> viewResolvers = new ArrayList<ViewResolver>(4);
    private final List<View> defaultViews = new ArrayList<View>(4);
    private final HttpRequestPathHelper pathHelper = new HttpRequestPathHelper();

    public ViewResolutionResultHandler(List<ViewResolver> resolvers, RequestedContentTypeResolver contentTypeResolver) {
        this(resolvers, contentTypeResolver, new ReactiveAdapterRegistry());
    }

    public ViewResolutionResultHandler(List<ViewResolver> resolvers, RequestedContentTypeResolver contentTypeResolver, ReactiveAdapterRegistry adapterRegistry) {
        super(contentTypeResolver, adapterRegistry);
        this.viewResolvers.addAll(resolvers);
        AnnotationAwareOrderComparator.sort(this.viewResolvers);
    }

    public List<ViewResolver> getViewResolvers() {
        return Collections.unmodifiableList(this.viewResolvers);
    }

    public void setDefaultViews(List<View> defaultViews) {
        this.defaultViews.clear();
        if (defaultViews != null) {
            this.defaultViews.addAll(defaultViews);
        }
    }

    public List<View> getDefaultViews() {
        return this.defaultViews;
    }

    @Override
    public boolean supports(HandlerResult result) {
        Class clazz = result.getReturnType().getRawClass();
        if (this.hasModelAttributeAnnotation(result)) {
            return true;
        }
        Optional<Object> optional = result.getReturnValue();
        ReactiveAdapter adapter = this.getAdapterRegistry().getAdapterFrom(clazz, optional);
        if (adapter != null) {
            if (adapter.getDescriptor().isNoValue()) {
                return true;
            }
            clazz = result.getReturnType().getGeneric(new int[]{0}).getRawClass();
            return this.isSupportedType(clazz);
        }
        return this.isSupportedType(clazz);
    }

    private boolean hasModelAttributeAnnotation(HandlerResult result) {
        MethodParameter returnType = result.getReturnTypeSource();
        return returnType.hasMethodAnnotation(ModelAttribute.class);
    }

    private boolean isSupportedType(Class<?> clazz) {
        return CharSequence.class.isAssignableFrom(clazz) || View.class.isAssignableFrom(clazz) || Model.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz) || !BeanUtils.isSimpleProperty(clazz);
    }

    @Override
    public Mono<Void> handleResult(ServerWebExchange exchange, HandlerResult result) {
        Mono viewMono;
        ResolvableType elementType;
        Mono valueMono;
        ResolvableType returnType = result.getReturnType();
        Optional<Object> optional = result.getReturnValue();
        ReactiveAdapter adapter = this.getAdapterRegistry().getAdapterFrom(returnType.getRawClass(), optional);
        if (adapter != null) {
            if (optional.isPresent()) {
                Mono converted = adapter.toMono(optional);
                valueMono = converted.map(o -> o);
            } else {
                valueMono = Mono.empty();
            }
            elementType = adapter.getDescriptor().isNoValue() ? ResolvableType.forClass(Void.class) : returnType.getGeneric(new int[]{0});
        } else {
            valueMono = Mono.justOrEmpty(result.getReturnValue());
            elementType = returnType;
        }
        if (this.isViewNameOrReference(elementType, result)) {
            Mono<Object> viewName = this.getDefaultViewNameMono(exchange, result);
            viewMono = valueMono.otherwiseIfEmpty(viewName);
        } else {
            viewMono = valueMono.map(value -> this.updateModel(value, result)).defaultIfEmpty((Object)result.getModel()).then(model -> this.getDefaultViewNameMono(exchange, result));
        }
        ModelMap model2 = result.getModel();
        return viewMono.then(arg_0 -> this.lambda$handleResult$3((Map)model2, exchange, arg_0));
    }

    private boolean isViewNameOrReference(ResolvableType elementType, HandlerResult result) {
        Class clazz = elementType.getRawClass();
        return View.class.isAssignableFrom(clazz) || CharSequence.class.isAssignableFrom(clazz) && !this.hasModelAttributeAnnotation(result);
    }

    private Mono<Object> getDefaultViewNameMono(ServerWebExchange exchange, HandlerResult result) {
        if (exchange.isNotModified()) {
            return Mono.empty();
        }
        String defaultViewName = this.getDefaultViewName(result, exchange);
        if (defaultViewName != null) {
            return Mono.just((Object)defaultViewName);
        }
        return Mono.error((Throwable)new IllegalStateException("Handler [" + result.getHandler() + "] neither returned a view name nor a View object"));
    }

    protected String getDefaultViewName(HandlerResult result, ServerWebExchange exchange) {
        String path = this.pathHelper.getLookupPathForRequest(exchange);
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return StringUtils.stripFilenameExtension((String)path);
    }

    private Object updateModel(Object value, HandlerResult result) {
        if (value instanceof Model) {
            result.getModel().addAllAttributes(((Model)value).asMap());
        } else if (value instanceof Map) {
            result.getModel().addAllAttributes((Map)value);
        } else {
            MethodParameter returnType = result.getReturnTypeSource();
            String name = ViewResolutionResultHandler.getNameForReturnValue(value, returnType);
            result.getModel().addAttribute(name, value);
        }
        return value;
    }

    private static String getNameForReturnValue(Object returnValue, MethodParameter returnType) {
        ModelAttribute annotation = (ModelAttribute)returnType.getMethodAnnotation(ModelAttribute.class);
        if (annotation != null && StringUtils.hasText((String)annotation.value())) {
            return annotation.value();
        }
        Method method = returnType.getMethod();
        Class containingClass = returnType.getContainingClass();
        Class resolvedType = GenericTypeResolver.resolveReturnType((Method)method, (Class)containingClass);
        return Conventions.getVariableNameForReturnType((Method)method, (Class)resolvedType, (Object)returnValue);
    }

    private Mono<? extends Void> resolveAndRender(String viewName, Locale locale, Map<String, ?> model, ServerWebExchange exchange) {
        return Flux.fromIterable(this.getViewResolvers()).concatMap(resolver -> resolver.resolveViewName(viewName, locale)).switchIfEmpty((Publisher)Mono.error((Throwable)new IllegalStateException("Could not resolve view with name '" + viewName + "'."))).collectList().then(views -> {
            views.addAll(this.getDefaultViews());
            List<MediaType> producibleTypes = this.getProducibleMediaTypes((List<View>)views);
            MediaType bestMediaType = this.selectMediaType(exchange, producibleTypes);
            if (bestMediaType != null) {
                for (View view : views) {
                    for (MediaType supported : view.getSupportedMediaTypes()) {
                        if (!supported.isCompatibleWith(bestMediaType)) continue;
                        return view.render(model, bestMediaType, exchange);
                    }
                }
            }
            return Mono.error((Throwable)new NotAcceptableStatusException(producibleTypes));
        });
    }

    private List<MediaType> getProducibleMediaTypes(List<View> views) {
        ArrayList<MediaType> result = new ArrayList<MediaType>();
        views.forEach(view -> result.addAll(view.getSupportedMediaTypes()));
        return result;
    }

    private /* synthetic */ Mono lambda$handleResult$3(Map model, ServerWebExchange exchange, Object view) {
        if (view instanceof View) {
            return ((View)view).render(model, null, exchange);
        }
        if (view instanceof CharSequence) {
            String viewName = view.toString();
            Locale locale = Locale.getDefault();
            return this.resolveAndRender(viewName, locale, model, exchange);
        }
        return Mono.error((Throwable)new IllegalStateException("Unexpected view type"));
    }
}

