/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.ConversionService;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.reactive.result.method.annotation.AbstractNamedValueMethodArgumentResolver;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.ServerWebInputException;
import reactor.core.publisher.Mono;

public class RequestParamMethodArgumentResolver
extends AbstractNamedValueMethodArgumentResolver {
    private final boolean useDefaultResolution;

    public RequestParamMethodArgumentResolver(ConversionService conversionService, ConfigurableBeanFactory beanFactory, boolean useDefaultResolution) {
        super(conversionService, beanFactory);
        this.useDefaultResolution = useDefaultResolution;
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        if (parameter.hasParameterAnnotation(RequestParam.class)) {
            if (Map.class.isAssignableFrom(parameter.nestedIfOptional().getNestedParameterType())) {
                String paramName = ((RequestParam)parameter.getParameterAnnotation(RequestParam.class)).name();
                return StringUtils.hasText((String)paramName);
            }
            return true;
        }
        return this.useDefaultResolution && BeanUtils.isSimpleProperty((Class)parameter.getNestedParameterType());
    }

    @Override
    protected AbstractNamedValueMethodArgumentResolver.NamedValueInfo createNamedValueInfo(MethodParameter parameter) {
        RequestParam ann = (RequestParam)parameter.getParameterAnnotation(RequestParam.class);
        return ann != null ? new RequestParamNamedValueInfo(ann) : new RequestParamNamedValueInfo();
    }

    @Override
    protected Mono<Object> resolveName(String name, MethodParameter parameter, ServerWebExchange exchange) {
        List paramValues = (List)exchange.getRequest().getQueryParams().get((Object)name);
        List result = null;
        if (paramValues != null) {
            result = paramValues.size() == 1 ? paramValues.get(0) : paramValues;
        }
        return Mono.justOrEmpty(result);
    }

    @Override
    protected void handleMissingValue(String name, MethodParameter parameter, ServerWebExchange exchange) {
        String type = parameter.getNestedParameterType().getSimpleName();
        String reason = "Required " + type + " parameter '" + name + "' is not present";
        throw new ServerWebInputException(reason, parameter);
    }

    private static class RequestParamNamedValueInfo
    extends AbstractNamedValueMethodArgumentResolver.NamedValueInfo {
        public RequestParamNamedValueInfo() {
            super("", false, "\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n");
        }

        public RequestParamNamedValueInfo(RequestParam annotation) {
            super(annotation.name(), annotation.required(), annotation.defaultValue());
        }
    }
}

