/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.ConversionService;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.reactive.result.method.annotation.AbstractNamedValueMethodArgumentResolver;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.ServerWebInputException;
import reactor.core.publisher.Mono;

public class RequestHeaderMethodArgumentResolver
extends AbstractNamedValueMethodArgumentResolver {
    public RequestHeaderMethodArgumentResolver(ConversionService conversionService, ConfigurableBeanFactory beanFactory) {
        super(conversionService, beanFactory);
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasParameterAnnotation(RequestHeader.class) && !Map.class.isAssignableFrom(parameter.nestedIfOptional().getNestedParameterType());
    }

    @Override
    protected AbstractNamedValueMethodArgumentResolver.NamedValueInfo createNamedValueInfo(MethodParameter parameter) {
        RequestHeader annotation = (RequestHeader)parameter.getParameterAnnotation(RequestHeader.class);
        return new RequestHeaderNamedValueInfo(annotation);
    }

    @Override
    protected Mono<Object> resolveName(String name, MethodParameter parameter, ServerWebExchange exchange) {
        List headerValues = exchange.getRequest().getHeaders().get((Object)name);
        List result = null;
        if (headerValues != null) {
            result = headerValues.size() == 1 ? headerValues.get(0) : headerValues;
        }
        return Mono.justOrEmpty(result);
    }

    @Override
    protected void handleMissingValue(String name, MethodParameter parameter) {
        String type = parameter.getNestedParameterType().getSimpleName();
        throw new ServerWebInputException("Missing request header '" + name + "' for method parameter of type " + type);
    }

    private static class RequestHeaderNamedValueInfo
    extends AbstractNamedValueMethodArgumentResolver.NamedValueInfo {
        private RequestHeaderNamedValueInfo(RequestHeader annotation) {
            super(annotation.name(), annotation.required(), annotation.defaultValue());
        }
    }
}

