/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.util.Optional;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.ConversionService;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.reactive.result.method.annotation.AbstractNamedValueMethodArgumentResolver;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.ServerWebInputException;
import reactor.core.publisher.Mono;

public class RequestAttributeMethodArgumentResolver
extends AbstractNamedValueMethodArgumentResolver {
    public RequestAttributeMethodArgumentResolver(ConversionService conversionService, ConfigurableBeanFactory beanFactory) {
        super(conversionService, beanFactory);
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasParameterAnnotation(RequestAttribute.class);
    }

    @Override
    protected AbstractNamedValueMethodArgumentResolver.NamedValueInfo createNamedValueInfo(MethodParameter parameter) {
        RequestAttribute annot = (RequestAttribute)parameter.getParameterAnnotation(RequestAttribute.class);
        return new AbstractNamedValueMethodArgumentResolver.NamedValueInfo(annot.name(), annot.required(), "\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n");
    }

    @Override
    protected Mono<Object> resolveName(String name, MethodParameter parameter, ServerWebExchange exchange) {
        return Mono.justOrEmpty((Optional)exchange.getAttribute(name));
    }

    @Override
    protected void handleMissingValue(String name, MethodParameter parameter) {
        String type = parameter.getNestedParameterType().getSimpleName();
        String reason = "Missing request attribute '" + name + "' of type " + type;
        throw new ServerWebInputException(reason, parameter);
    }
}

