/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.ConversionService;
import org.springframework.web.reactive.result.method.annotation.AbstractNamedValueMethodArgumentResolver;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class ExpressionValueMethodArgumentResolver
extends AbstractNamedValueMethodArgumentResolver {
    public ExpressionValueMethodArgumentResolver(ConversionService conversionService, ConfigurableBeanFactory beanFactory) {
        super(conversionService, beanFactory);
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasParameterAnnotation(Value.class);
    }

    @Override
    protected AbstractNamedValueMethodArgumentResolver.NamedValueInfo createNamedValueInfo(MethodParameter parameter) {
        Value annotation = (Value)parameter.getParameterAnnotation(Value.class);
        return new ExpressionValueNamedValueInfo(annotation);
    }

    @Override
    protected Mono<Object> resolveName(String name, MethodParameter parameter, ServerWebExchange exchange) {
        return Mono.empty();
    }

    @Override
    protected void handleMissingValue(String name, MethodParameter parameter) {
        throw new UnsupportedOperationException("@Value is never required: " + parameter.getMethod());
    }

    private static class ExpressionValueNamedValueInfo
    extends AbstractNamedValueMethodArgumentResolver.NamedValueInfo {
        private ExpressionValueNamedValueInfo(Value annotation) {
            super("@Value", false, annotation.value());
        }
    }
}

