/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.MethodIntrospector;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.reactive.handler.AbstractHandlerMapping;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public abstract class AbstractHandlerMethodMapping<T>
extends AbstractHandlerMapping
implements InitializingBean {
    private static final String SCOPED_TARGET_NAME_PREFIX = "scopedTarget.";
    private final MappingRegistry mappingRegistry = new MappingRegistry();

    public Map<T, HandlerMethod> getHandlerMethods() {
        this.mappingRegistry.acquireReadLock();
        try {
            Map map = Collections.unmodifiableMap(this.mappingRegistry.getMappings());
            return map;
        }
        finally {
            this.mappingRegistry.releaseReadLock();
        }
    }

    MappingRegistry getMappingRegistry() {
        return this.mappingRegistry;
    }

    public void registerMapping(T mapping, Object handler, Method method) {
        this.mappingRegistry.register(mapping, handler, method);
    }

    public void unregisterMapping(T mapping) {
        this.mappingRegistry.unregister(mapping);
    }

    public void afterPropertiesSet() {
        this.initHandlerMethods();
    }

    protected void initHandlerMethods() {
        String[] beanNames;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Looking for request mappings in application context: " + this.getApplicationContext()));
        }
        for (String beanName : beanNames = this.getApplicationContext().getBeanNamesForType(Object.class)) {
            Class beanType;
            block4: {
                if (beanName.startsWith(SCOPED_TARGET_NAME_PREFIX)) continue;
                beanType = null;
                try {
                    beanType = this.getApplicationContext().getType(beanName);
                }
                catch (Throwable ex) {
                    if (!this.logger.isDebugEnabled()) break block4;
                    this.logger.debug((Object)("Could not resolve target class for bean with name '" + beanName + "'"), ex);
                }
            }
            if (beanType == null || !this.isHandler(beanType)) continue;
            this.detectHandlerMethods(beanName);
        }
        this.handlerMethodsInitialized(this.getHandlerMethods());
    }

    protected void detectHandlerMethods(Object handler) {
        Class handlerType = handler instanceof String ? this.getApplicationContext().getType((String)handler) : handler.getClass();
        Class userType = ClassUtils.getUserClass((Class)handlerType);
        Map methods = MethodIntrospector.selectMethods((Class)userType, method -> this.getMappingForMethod(method, userType));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(methods.size() + " request handler methods found on " + userType + ": " + methods));
        }
        for (Map.Entry entry : methods.entrySet()) {
            Method invocableMethod = AopUtils.selectInvocableMethod((Method)((Method)entry.getKey()), (Class)userType);
            Object mapping = entry.getValue();
            this.registerHandlerMethod(handler, invocableMethod, mapping);
        }
    }

    protected void registerHandlerMethod(Object handler, Method method, T mapping) {
        this.mappingRegistry.register(mapping, handler, method);
    }

    protected HandlerMethod createHandlerMethod(Object handler, Method method) {
        HandlerMethod handlerMethod;
        if (handler instanceof String) {
            String beanName = (String)handler;
            handlerMethod = new HandlerMethod(beanName, (BeanFactory)this.getApplicationContext().getAutowireCapableBeanFactory(), method);
        } else {
            handlerMethod = new HandlerMethod(handler, method);
        }
        return handlerMethod;
    }

    protected void handlerMethodsInitialized(Map<T, HandlerMethod> handlerMethods) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Mono<Object> getHandler(ServerWebExchange exchange) {
        String lookupPath = this.getPathHelper().getLookupPathForRequest(exchange);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Looking up handler method for path " + lookupPath));
        }
        this.mappingRegistry.acquireReadLock();
        try {
            HandlerMethod handlerMethod = null;
            try {
                handlerMethod = this.lookupHandlerMethod(lookupPath, exchange);
            }
            catch (Exception ex) {
                Mono mono = Mono.error((Throwable)ex);
                this.mappingRegistry.releaseReadLock();
                return mono;
            }
            if (this.logger.isDebugEnabled()) {
                if (handlerMethod != null) {
                    this.logger.debug((Object)("Returning handler method [" + handlerMethod + "]"));
                } else {
                    this.logger.debug((Object)("Did not find handler method for [" + lookupPath + "]"));
                }
            }
            Mono mono = handlerMethod != null ? Mono.just((Object)handlerMethod.createWithResolvedBean()) : Mono.empty();
            return mono;
        }
        finally {
            this.mappingRegistry.releaseReadLock();
        }
    }

    protected HandlerMethod lookupHandlerMethod(String lookupPath, ServerWebExchange exchange) throws Exception {
        ArrayList<Match> matches = new ArrayList<Match>();
        List directPathMatches = this.mappingRegistry.getMappingsByUrl(lookupPath);
        if (directPathMatches != null) {
            this.addMatchingMappings(directPathMatches, matches, exchange);
        }
        if (matches.isEmpty()) {
            this.addMatchingMappings(this.mappingRegistry.getMappings().keySet(), matches, exchange);
        }
        if (!matches.isEmpty()) {
            Match secondBestMatch;
            MatchComparator comparator = new MatchComparator(this.getMappingComparator(exchange));
            Collections.sort(matches, comparator);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Found " + matches.size() + " matching mapping(s) for [" + lookupPath + "] : " + matches));
            }
            Match bestMatch = (Match)matches.get(0);
            if (matches.size() > 1 && comparator.compare(bestMatch, secondBestMatch = (Match)matches.get(1)) == 0) {
                Method m1 = bestMatch.handlerMethod.getMethod();
                Method m2 = secondBestMatch.handlerMethod.getMethod();
                throw new IllegalStateException("Ambiguous handler methods mapped for HTTP path '" + lookupPath + "': {" + m1 + ", " + m2 + "}");
            }
            this.handleMatch(bestMatch.mapping, lookupPath, exchange);
            return bestMatch.handlerMethod;
        }
        return this.handleNoMatch(this.mappingRegistry.getMappings().keySet(), lookupPath, exchange);
    }

    private void addMatchingMappings(Collection<T> mappings, List<Match> matches, ServerWebExchange exchange) {
        for (T mapping : mappings) {
            T match = this.getMatchingMapping(mapping, exchange);
            if (match == null) continue;
            matches.add(new Match(match, this.mappingRegistry.getMappings().get(mapping)));
        }
    }

    protected void handleMatch(T mapping, String lookupPath, ServerWebExchange exchange) {
    }

    protected HandlerMethod handleNoMatch(Set<T> mappings, String lookupPath, ServerWebExchange exchange) throws Exception {
        return null;
    }

    protected abstract boolean isHandler(Class<?> var1);

    protected abstract T getMappingForMethod(Method var1, Class<?> var2);

    protected abstract Set<String> getMappingPathPatterns(T var1);

    protected abstract T getMatchingMapping(T var1, ServerWebExchange var2);

    protected abstract Comparator<T> getMappingComparator(ServerWebExchange var1);

    private class MatchComparator
    implements Comparator<Match> {
        private final Comparator<T> comparator;

        public MatchComparator(Comparator<T> comparator) {
            this.comparator = comparator;
        }

        @Override
        public int compare(Match match1, Match match2) {
            return this.comparator.compare(match1.mapping, match2.mapping);
        }
    }

    private class Match {
        private final T mapping;
        private final HandlerMethod handlerMethod;

        public Match(T mapping, HandlerMethod handlerMethod) {
            this.mapping = mapping;
            this.handlerMethod = handlerMethod;
        }

        public String toString() {
            return this.mapping.toString();
        }
    }

    private static class MappingRegistration<T> {
        private final T mapping;
        private final HandlerMethod handlerMethod;
        private final List<String> directUrls;

        public MappingRegistration(T mapping, HandlerMethod handlerMethod, List<String> directUrls) {
            Assert.notNull(mapping);
            Assert.notNull((Object)handlerMethod);
            this.mapping = mapping;
            this.handlerMethod = handlerMethod;
            this.directUrls = directUrls != null ? directUrls : Collections.emptyList();
        }

        public T getMapping() {
            return this.mapping;
        }

        public HandlerMethod getHandlerMethod() {
            return this.handlerMethod;
        }

        public List<String> getDirectUrls() {
            return this.directUrls;
        }
    }

    class MappingRegistry {
        private final Map<T, MappingRegistration<T>> registry = new HashMap();
        private final Map<T, HandlerMethod> mappingLookup = new LinkedHashMap();
        private final MultiValueMap<String, T> urlLookup = new LinkedMultiValueMap();
        private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();

        MappingRegistry() {
        }

        public Map<T, HandlerMethod> getMappings() {
            return this.mappingLookup;
        }

        public List<T> getMappingsByUrl(String urlPath) {
            return (List)this.urlLookup.get((Object)urlPath);
        }

        public void acquireReadLock() {
            this.readWriteLock.readLock().lock();
        }

        public void releaseReadLock() {
            this.readWriteLock.readLock().unlock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void register(T mapping, Object handler, Method method) {
            this.readWriteLock.writeLock().lock();
            try {
                HandlerMethod handlerMethod = AbstractHandlerMethodMapping.this.createHandlerMethod(handler, method);
                this.assertUniqueMethodMapping(handlerMethod, mapping);
                if (AbstractHandlerMethodMapping.this.logger.isInfoEnabled()) {
                    AbstractHandlerMethodMapping.this.logger.info((Object)("Mapped \"" + mapping + "\" onto " + handlerMethod));
                }
                this.mappingLookup.put(mapping, handlerMethod);
                List<String> directUrls = this.getDirectUrls(mapping);
                for (String url : directUrls) {
                    this.urlLookup.add((Object)url, mapping);
                }
                this.registry.put(mapping, new MappingRegistration(mapping, handlerMethod, directUrls));
            }
            finally {
                this.readWriteLock.writeLock().unlock();
            }
        }

        private void assertUniqueMethodMapping(HandlerMethod newHandlerMethod, T mapping) {
            HandlerMethod handlerMethod = this.mappingLookup.get(mapping);
            if (handlerMethod != null && !handlerMethod.equals((Object)newHandlerMethod)) {
                throw new IllegalStateException("Ambiguous mapping. Cannot map '" + newHandlerMethod.getBean() + "' method \n" + newHandlerMethod + "\nto " + mapping + ": There is already '" + handlerMethod.getBean() + "' bean method\n" + handlerMethod + " mapped.");
            }
        }

        private List<String> getDirectUrls(T mapping) {
            ArrayList<String> urls = new ArrayList<String>(1);
            for (String path : AbstractHandlerMethodMapping.this.getMappingPathPatterns(mapping)) {
                if (AbstractHandlerMethodMapping.this.getPathMatcher().isPattern(path)) continue;
                urls.add(path);
            }
            return urls;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregister(T mapping) {
            this.readWriteLock.writeLock().lock();
            try {
                MappingRegistration definition = this.registry.remove(mapping);
                if (definition == null) {
                    return;
                }
                this.mappingLookup.remove(definition.getMapping());
                for (String url : definition.getDirectUrls()) {
                    List list = (List)this.urlLookup.get((Object)url);
                    if (list == null) continue;
                    list.remove(definition.getMapping());
                    if (!list.isEmpty()) continue;
                    this.urlLookup.remove((Object)url);
                }
            }
            finally {
                this.readWriteLock.writeLock().unlock();
            }
        }
    }
}

