/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.springframework.core.Ordered;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.reactive.accept.RequestedContentTypeResolver;
import org.springframework.web.server.ServerWebExchange;

public abstract class ContentNegotiatingResultHandlerSupport
implements Ordered {
    private static final MediaType MEDIA_TYPE_APPLICATION_ALL = new MediaType("application");
    private final RequestedContentTypeResolver contentTypeResolver;
    private final ReactiveAdapterRegistry adapterRegistry;
    private int order = Integer.MAX_VALUE;

    protected ContentNegotiatingResultHandlerSupport(RequestedContentTypeResolver contentTypeResolver) {
        this(contentTypeResolver, new ReactiveAdapterRegistry());
    }

    protected ContentNegotiatingResultHandlerSupport(RequestedContentTypeResolver contentTypeResolver, ReactiveAdapterRegistry adapterRegistry) {
        Assert.notNull((Object)contentTypeResolver, (String)"'contentTypeResolver' is required.");
        Assert.notNull((Object)adapterRegistry, (String)"'adapterRegistry' is required.");
        this.contentTypeResolver = contentTypeResolver;
        this.adapterRegistry = adapterRegistry;
    }

    public ReactiveAdapterRegistry getAdapterRegistry() {
        return this.adapterRegistry;
    }

    public RequestedContentTypeResolver getContentTypeResolver() {
        return this.contentTypeResolver;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    protected MediaType selectMediaType(ServerWebExchange exchange, List<MediaType> producibleTypes) {
        List<MediaType> acceptableTypes = this.getAcceptableTypes(exchange);
        producibleTypes = this.getProducibleTypes(exchange, producibleTypes);
        LinkedHashSet<MediaType> compatibleMediaTypes = new LinkedHashSet<MediaType>();
        for (MediaType acceptable : acceptableTypes) {
            for (MediaType producible : producibleTypes) {
                if (!acceptable.isCompatibleWith(producible)) continue;
                compatibleMediaTypes.add(this.selectMoreSpecificMediaType(acceptable, producible));
            }
        }
        ArrayList result = new ArrayList(compatibleMediaTypes);
        MediaType.sortBySpecificityAndQuality(result);
        for (MediaType mediaType : compatibleMediaTypes) {
            if (mediaType.isConcrete()) {
                return mediaType;
            }
            if (!mediaType.equals((Object)MediaType.ALL) && !mediaType.equals((Object)MEDIA_TYPE_APPLICATION_ALL)) continue;
            return MediaType.APPLICATION_OCTET_STREAM;
        }
        return null;
    }

    private List<MediaType> getAcceptableTypes(ServerWebExchange exchange) {
        List<MediaType> mediaTypes = this.getContentTypeResolver().resolveMediaTypes(exchange);
        return mediaTypes.isEmpty() ? Collections.singletonList(MediaType.ALL) : mediaTypes;
    }

    private List<MediaType> getProducibleTypes(ServerWebExchange exchange, List<MediaType> mediaTypes) {
        Optional optional = exchange.getAttribute(HandlerMapping.PRODUCIBLE_MEDIA_TYPES_ATTRIBUTE);
        if (optional.isPresent()) {
            Set set = (Set)optional.get();
            return new ArrayList<MediaType>(set);
        }
        return mediaTypes;
    }

    private MediaType selectMoreSpecificMediaType(MediaType acceptable, MediaType producible) {
        Comparator comparator = MediaType.SPECIFICITY_COMPARATOR;
        return comparator.compare(acceptable, producible = producible.copyQualityValue(acceptable)) <= 0 ? acceptable : producible;
    }
}

