/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.resource;

import java.util.List;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.web.reactive.resource.AbstractResourceResolver;
import org.springframework.web.reactive.resource.ResourceResolverChain;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class CachingResourceResolver
extends AbstractResourceResolver {
    public static final String RESOLVED_RESOURCE_CACHE_KEY_PREFIX = "resolvedResource:";
    public static final String RESOLVED_URL_PATH_CACHE_KEY_PREFIX = "resolvedUrlPath:";
    private final Cache cache;

    public CachingResourceResolver(CacheManager cacheManager, String cacheName) {
        this(cacheManager.getCache(cacheName));
    }

    public CachingResourceResolver(Cache cache) {
        Assert.notNull((Object)cache, (String)"Cache is required");
        this.cache = cache;
    }

    public Cache getCache() {
        return this.cache;
    }

    @Override
    protected Mono<Resource> resolveResourceInternal(ServerWebExchange exchange, String requestPath, List<? extends Resource> locations, ResourceResolverChain chain) {
        String key = this.computeKey(exchange, requestPath);
        Resource cachedResource = (Resource)this.cache.get((Object)key, Resource.class);
        if (cachedResource != null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Found match: " + cachedResource));
            }
            return Mono.just((Object)cachedResource);
        }
        return chain.resolveResource(exchange, requestPath, locations).doOnNext(resource -> {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Putting resolved resource in cache: " + resource));
            }
            this.cache.put((Object)key, resource);
        });
    }

    protected String computeKey(ServerWebExchange exchange, String requestPath) {
        String encoding;
        StringBuilder key = new StringBuilder(RESOLVED_RESOURCE_CACHE_KEY_PREFIX);
        key.append(requestPath);
        if (exchange != null && (encoding = exchange.getRequest().getHeaders().getFirst("Accept-Encoding")) != null && encoding.contains("gzip")) {
            key.append("+encoding=gzip");
        }
        return key.toString();
    }

    @Override
    protected Mono<String> resolveUrlPathInternal(String resourceUrlPath, List<? extends Resource> locations, ResourceResolverChain chain) {
        String key = RESOLVED_URL_PATH_CACHE_KEY_PREFIX + resourceUrlPath;
        String cachedUrlPath = (String)this.cache.get((Object)key, String.class);
        if (cachedUrlPath != null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Found match: \"" + cachedUrlPath + "\""));
            }
            return Mono.just((Object)cachedUrlPath);
        }
        return chain.resolveUrlPath(resourceUrlPath, locations).doOnNext(resolvedPath -> {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Putting resolved resource URL path in cache: \"" + resolvedPath + "\""));
            }
            this.cache.put((Object)key, resolvedPath);
        });
    }
}

