/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.resource;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.web.reactive.resource.ResourceResolver;
import org.springframework.web.reactive.resource.ResourceResolverChain;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public abstract class AbstractResourceResolver
implements ResourceResolver {
    protected final Log logger = LogFactory.getLog(this.getClass());

    @Override
    public Mono<Resource> resolveResource(ServerWebExchange exchange, String requestPath, List<? extends Resource> locations, ResourceResolverChain chain) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Resolving resource for request path \"" + requestPath + "\""));
        }
        return this.resolveResourceInternal(exchange, requestPath, locations, chain);
    }

    @Override
    public Mono<String> resolveUrlPath(String resourceUrlPath, List<? extends Resource> locations, ResourceResolverChain chain) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Resolving public URL for resource path \"" + resourceUrlPath + "\""));
        }
        return this.resolveUrlPathInternal(resourceUrlPath, locations, chain);
    }

    protected abstract Mono<Resource> resolveResourceInternal(ServerWebExchange var1, String var2, List<? extends Resource> var3, ResourceResolverChain var4);

    protected abstract Mono<String> resolveUrlPathInternal(String var1, List<? extends Resource> var2, ResourceResolverChain var3);
}

