/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.support;

import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRange;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.web.reactive.function.BodyExtractor;
import org.springframework.web.reactive.function.Request;

public class RequestWrapper
implements Request {
    private final Request request;

    public RequestWrapper(Request request) {
        Assert.notNull((Object)request, (String)"'request' must not be null");
        this.request = request;
    }

    public Request request() {
        return this.request;
    }

    @Override
    public HttpMethod method() {
        return this.request.method();
    }

    @Override
    public URI uri() {
        return this.request.uri();
    }

    @Override
    public String path() {
        return this.request.path();
    }

    @Override
    public Request.Headers headers() {
        return this.request.headers();
    }

    @Override
    public <T> T body(BodyExtractor<T> extractor) {
        return this.request.body(extractor);
    }

    @Override
    public <T> Optional<T> attribute(String name) {
        return this.request.attribute(name);
    }

    @Override
    public Optional<String> queryParam(String name) {
        return this.request.queryParam(name);
    }

    @Override
    public List<String> queryParams(String name) {
        return this.request.queryParams(name);
    }

    @Override
    public Optional<String> pathVariable(String name) {
        return this.request.pathVariable(name);
    }

    @Override
    public Map<String, String> pathVariables() {
        return this.request.pathVariables();
    }

    public static class HeadersWrapper
    implements Request.Headers {
        private final Request.Headers headers;

        public HeadersWrapper(Request.Headers headers) {
            Assert.notNull((Object)headers, (String)"'headers' must not be null");
            this.headers = headers;
        }

        @Override
        public List<MediaType> accept() {
            return this.headers.accept();
        }

        @Override
        public List<Charset> acceptCharset() {
            return this.headers.acceptCharset();
        }

        @Override
        public OptionalLong contentLength() {
            return this.headers.contentLength();
        }

        @Override
        public Optional<MediaType> contentType() {
            return this.headers.contentType();
        }

        @Override
        public InetSocketAddress host() {
            return this.headers.host();
        }

        @Override
        public List<HttpRange> range() {
            return this.headers.range();
        }

        @Override
        public List<String> header(String headerName) {
            return this.headers.header(headerName);
        }

        @Override
        public HttpHeaders asHttpHeaders() {
            return this.headers.asHttpHeaders();
        }
    }
}

