/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.support;

import java.lang.reflect.Method;
import org.springframework.core.MethodParameter;
import org.springframework.web.reactive.HandlerAdapter;
import org.springframework.web.reactive.HandlerResult;
import org.springframework.web.reactive.function.HandlerFunction;
import org.springframework.web.reactive.function.Request;
import org.springframework.web.reactive.function.Response;
import org.springframework.web.reactive.function.RouterFunctions;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class HandlerFunctionAdapter
implements HandlerAdapter {
    private static final MethodParameter HANDLER_FUNCTION_RETURN_TYPE;

    @Override
    public boolean supports(Object handler) {
        return handler instanceof HandlerFunction;
    }

    @Override
    public Mono<HandlerResult> handle(ServerWebExchange exchange, Object handler) {
        HandlerFunction handlerFunction = (HandlerFunction)handler;
        Request request = (Request)exchange.getAttribute(RouterFunctions.REQUEST_ATTRIBUTE).orElseThrow(() -> new IllegalStateException("Could not find Request in exchange attributes"));
        Response response = handlerFunction.handle(request);
        HandlerResult handlerResult = new HandlerResult(handlerFunction, response, HANDLER_FUNCTION_RETURN_TYPE);
        return Mono.just((Object)handlerResult);
    }

    static {
        try {
            Method method = HandlerFunction.class.getMethod("handle", Request.class);
            HANDLER_FUNCTION_RETURN_TYPE = new MethodParameter(method, -1);
        }
        catch (NoSuchMethodException ex) {
            throw new Error(ex);
        }
    }
}

