/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function;

import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.DefaultResponseBuilder;
import org.springframework.web.reactive.function.Rendering;
import org.springframework.web.reactive.function.StrategiesSupplier;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public interface Response<T> {
    public HttpStatus statusCode();

    public HttpHeaders headers();

    public T body();

    public Mono<Void> writeTo(ServerWebExchange var1, StrategiesSupplier var2);

    public static BodyBuilder from(Response<?> other) {
        Assert.notNull(other, (String)"'other' must not be null");
        DefaultResponseBuilder builder = new DefaultResponseBuilder(other.statusCode().value());
        return builder.headers(other.headers());
    }

    public static BodyBuilder status(HttpStatus status) {
        Assert.notNull((Object)status, (String)"HttpStatus must not be null");
        return new DefaultResponseBuilder(status.value());
    }

    public static BodyBuilder status(int status) {
        return new DefaultResponseBuilder(status);
    }

    public static BodyBuilder ok() {
        return Response.status(HttpStatus.OK);
    }

    public static BodyBuilder created(URI location) {
        BodyBuilder builder = Response.status(HttpStatus.CREATED);
        return (BodyBuilder)builder.location(location);
    }

    public static BodyBuilder accepted() {
        return Response.status(HttpStatus.ACCEPTED);
    }

    public static HeadersBuilder<?> noContent() {
        return Response.status(HttpStatus.NO_CONTENT);
    }

    public static BodyBuilder badRequest() {
        return Response.status(HttpStatus.BAD_REQUEST);
    }

    public static HeadersBuilder<?> notFound() {
        return Response.status(HttpStatus.NOT_FOUND);
    }

    public static BodyBuilder unprocessableEntity() {
        return Response.status(HttpStatus.UNPROCESSABLE_ENTITY);
    }

    public static interface BodyBuilder
    extends HeadersBuilder<BodyBuilder> {
        public BodyBuilder contentLength(long var1);

        public BodyBuilder contentType(MediaType var1);

        public <T> Response<T> body(BiFunction<ServerHttpResponse, StrategiesSupplier, Mono<Void>> var1, Supplier<T> var2);

        public <T> Response<T> body(BodyInserter<T> var1);

        public Response<Rendering> render(String var1, Object ... var2);

        public Response<Rendering> render(String var1, Map<String, ?> var2);
    }

    public static interface HeadersBuilder<B extends HeadersBuilder<B>> {
        public B header(String var1, String ... var2);

        public B headers(HttpHeaders var1);

        public B allow(HttpMethod ... var1);

        public B eTag(String var1);

        public B lastModified(ZonedDateTime var1);

        public B location(URI var1);

        public B cacheControl(CacheControl var1);

        public B varyBy(String ... var1);

        public Response<Void> build();

        public <T extends Publisher<Void>> Response<T> build(T var1);
    }
}

