/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function;

import java.util.Collections;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ReactiveHttpOutputMessage;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.http.codec.ResourceHttpMessageWriter;
import org.springframework.http.codec.ServerSentEvent;
import org.springframework.http.codec.ServerSentEventHttpMessageWriter;
import org.springframework.http.codec.json.Jackson2JsonEncoder;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.StrategiesSupplier;
import reactor.core.publisher.Mono;

public abstract class BodyInserters {
    private static final ResolvableType RESOURCE_TYPE = ResolvableType.forClass(Resource.class);
    private static final ResolvableType SERVER_SIDE_EVENT_TYPE = ResolvableType.forClass(ServerSentEvent.class);
    private static final boolean jackson2Present = ClassUtils.isPresent((String)"com.fasterxml.jackson.databind.ObjectMapper", (ClassLoader)BodyInserters.class.getClassLoader()) && ClassUtils.isPresent((String)"com.fasterxml.jackson.core.JsonGenerator", (ClassLoader)BodyInserters.class.getClassLoader());

    public static <T> BodyInserter<T> fromObject(T body) {
        Assert.notNull(body, (String)"'body' must not be null");
        return BodyInserter.of((response, strategies) -> BodyInserters.writeWithMessageWriters(response, strategies, Mono.just((Object)body), ResolvableType.forInstance((Object)body)), () -> body);
    }

    public static <S extends Publisher<T>, T> BodyInserter<S> fromPublisher(S publisher, Class<T> elementClass) {
        Assert.notNull(publisher, (String)"'publisher' must not be null");
        Assert.notNull(elementClass, (String)"'elementClass' must not be null");
        return BodyInserters.fromPublisher(publisher, ResolvableType.forClass(elementClass));
    }

    public static <S extends Publisher<T>, T> BodyInserter<S> fromPublisher(S publisher, ResolvableType elementType) {
        Assert.notNull(publisher, (String)"'publisher' must not be null");
        Assert.notNull((Object)elementType, (String)"'elementType' must not be null");
        return BodyInserter.of((response, strategies) -> BodyInserters.writeWithMessageWriters(response, strategies, publisher, elementType), () -> publisher);
    }

    public static <T extends Resource> BodyInserter<T> fromResource(T resource) {
        Assert.notNull(resource, (String)"'resource' must not be null");
        return BodyInserter.of((response, strategies) -> {
            ResourceHttpMessageWriter messageWriter = new ResourceHttpMessageWriter();
            MediaType contentType = response.getHeaders().getContentType();
            return messageWriter.write((Publisher)Mono.just((Object)resource), RESOURCE_TYPE, contentType, (ReactiveHttpOutputMessage)response, Collections.emptyMap());
        }, () -> resource);
    }

    public static <T, S extends Publisher<ServerSentEvent<T>>> BodyInserter<S> fromServerSentEvents(S eventsPublisher) {
        Assert.notNull(eventsPublisher, (String)"'eventsPublisher' must not be null");
        return BodyInserter.of((response, strategies) -> {
            ServerSentEventHttpMessageWriter messageWriter = BodyInserters.sseMessageWriter();
            MediaType contentType = response.getHeaders().getContentType();
            return messageWriter.write(eventsPublisher, SERVER_SIDE_EVENT_TYPE, contentType, (ReactiveHttpOutputMessage)response, Collections.emptyMap());
        }, () -> eventsPublisher);
    }

    public static <T, S extends Publisher<T>> BodyInserter<S> fromServerSentEvents(S eventsPublisher, Class<T> eventClass) {
        Assert.notNull(eventsPublisher, (String)"'eventsPublisher' must not be null");
        Assert.notNull(eventClass, (String)"'eventClass' must not be null");
        return BodyInserters.fromServerSentEvents(eventsPublisher, ResolvableType.forClass(eventClass));
    }

    public static <T, S extends Publisher<T>> BodyInserter<S> fromServerSentEvents(S eventsPublisher, ResolvableType eventType) {
        Assert.notNull(eventsPublisher, (String)"'eventsPublisher' must not be null");
        Assert.notNull((Object)eventType, (String)"'eventType' must not be null");
        return BodyInserter.of((response, strategies) -> {
            ServerSentEventHttpMessageWriter messageWriter = BodyInserters.sseMessageWriter();
            MediaType contentType = response.getHeaders().getContentType();
            return messageWriter.write(eventsPublisher, eventType, contentType, (ReactiveHttpOutputMessage)response, Collections.emptyMap());
        }, () -> eventsPublisher);
    }

    private static ServerSentEventHttpMessageWriter sseMessageWriter() {
        return jackson2Present ? new ServerSentEventHttpMessageWriter(Collections.singletonList(new Jackson2JsonEncoder())) : new ServerSentEventHttpMessageWriter();
    }

    private static <T> Mono<Void> writeWithMessageWriters(ServerHttpResponse response, StrategiesSupplier strategies, Publisher<T> body, ResolvableType bodyType) {
        MediaType contentType = response.getHeaders().getContentType();
        return strategies.messageWriters().get().filter(messageWriter -> messageWriter.canWrite(bodyType, contentType)).findFirst().map(BodyInserters::cast).map(messageWriter -> messageWriter.write(body, bodyType, contentType, (ReactiveHttpOutputMessage)response, Collections.emptyMap())).orElseGet(() -> {
            response.setStatusCode(HttpStatus.NOT_ACCEPTABLE);
            return response.setComplete();
        });
    }

    private static <T> HttpMessageWriter<T> cast(HttpMessageWriter<?> messageWriter) {
        return messageWriter;
    }

    static class DefaultBodyInserter<T>
    implements BodyInserter<T> {
        private final BiFunction<ServerHttpResponse, StrategiesSupplier, Mono<Void>> writer;
        private final Supplier<T> supplier;

        public DefaultBodyInserter(BiFunction<ServerHttpResponse, StrategiesSupplier, Mono<Void>> writer, Supplier<T> supplier) {
            this.writer = writer;
            this.supplier = supplier;
        }

        @Override
        public Mono<Void> insert(ServerHttpResponse response, StrategiesSupplier strategies) {
            return this.writer.apply(response, strategies);
        }

        @Override
        public T t() {
            return this.supplier.get();
        }
    }
}

