/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.http.MediaType;
import org.springframework.http.ReactiveHttpInputMessage;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.Assert;
import org.springframework.web.reactive.function.BodyExtractor;
import org.springframework.web.reactive.function.StrategiesSupplier;
import org.springframework.web.server.UnsupportedMediaTypeStatusException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class BodyExtractors {
    public static <T> BodyExtractor<Mono<T>> toMono(Class<? extends T> elementClass) {
        Assert.notNull(elementClass, (String)"'elementClass' must not be null");
        return BodyExtractors.toMono(ResolvableType.forClass(elementClass));
    }

    public static <T> BodyExtractor<Mono<T>> toMono(ResolvableType elementType) {
        Assert.notNull((Object)elementType, (String)"'elementType' must not be null");
        return (request, strategies) -> BodyExtractors.readWithMessageReaders(request, strategies, elementType, reader -> reader.readMono(elementType, (ReactiveHttpInputMessage)request, Collections.emptyMap()), Mono::error);
    }

    public static <T> BodyExtractor<Flux<T>> toFlux(Class<? extends T> elementClass) {
        Assert.notNull(elementClass, (String)"'elementClass' must not be null");
        return BodyExtractors.toFlux(ResolvableType.forClass(elementClass));
    }

    public static <T> BodyExtractor<Flux<T>> toFlux(ResolvableType elementType) {
        Assert.notNull((Object)elementType, (String)"'elementType' must not be null");
        return (request, strategies) -> BodyExtractors.readWithMessageReaders(request, strategies, elementType, reader -> reader.read(elementType, (ReactiveHttpInputMessage)request, Collections.emptyMap()), Flux::error);
    }

    private static <T, S extends Publisher<T>> S readWithMessageReaders(ServerHttpRequest request, StrategiesSupplier strategies, ResolvableType elementType, Function<HttpMessageReader<T>, S> readerFunction, Function<Throwable, S> unsupportedError) {
        MediaType contentType = BodyExtractors.contentType(request);
        Supplier<Stream<HttpMessageReader<?>>> messageReaders = strategies.messageReaders();
        return (S)messageReaders.get().filter(r -> r.canRead(elementType, contentType)).findFirst().map(BodyExtractors::cast).map(readerFunction).orElseGet(() -> {
            List supportedMediaTypes = ((Stream)messageReaders.get()).flatMap(reader -> reader.getReadableMediaTypes().stream()).collect(Collectors.toList());
            UnsupportedMediaTypeStatusException error = new UnsupportedMediaTypeStatusException(contentType, supportedMediaTypes);
            return (Publisher)unsupportedError.apply(error);
        });
    }

    private static MediaType contentType(ServerHttpRequest request) {
        MediaType result = request.getHeaders().getContentType();
        return result != null ? result : MediaType.APPLICATION_OCTET_STREAM;
    }

    private static <T> HttpMessageReader<T> cast(HttpMessageReader<?> messageReader) {
        return messageReader;
    }
}

