/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.web.reactive.accept.CompositeContentTypeResolver;
import org.springframework.web.reactive.config.ResourceHandlerRegistration;
import org.springframework.web.reactive.handler.AbstractHandlerMapping;
import org.springframework.web.reactive.handler.SimpleUrlHandlerMapping;
import org.springframework.web.reactive.resource.ResourceWebHandler;

public class ResourceHandlerRegistry {
    private final ApplicationContext applicationContext;
    private final CompositeContentTypeResolver contentTypeResolver;
    private final List<ResourceHandlerRegistration> registrations = new ArrayList<ResourceHandlerRegistration>();
    private int order = 0x7FFFFFFE;

    public ResourceHandlerRegistry(ApplicationContext applicationContext) {
        this(applicationContext, null);
    }

    public ResourceHandlerRegistry(ApplicationContext applicationContext, CompositeContentTypeResolver contentTypeResolver) {
        Assert.notNull((Object)applicationContext, (String)"ApplicationContext is required");
        this.applicationContext = applicationContext;
        this.contentTypeResolver = contentTypeResolver;
    }

    public ResourceHandlerRegistration addResourceHandler(String ... patterns) {
        ResourceHandlerRegistration registration = new ResourceHandlerRegistration((ResourceLoader)this.applicationContext, patterns);
        this.registrations.add(registration);
        return registration;
    }

    public boolean hasMappingForPattern(String pathPattern) {
        for (ResourceHandlerRegistration registration : this.registrations) {
            if (!Arrays.asList(registration.getPathPatterns()).contains(pathPattern)) continue;
            return true;
        }
        return false;
    }

    public ResourceHandlerRegistry setOrder(int order) {
        this.order = order;
        return this;
    }

    protected AbstractHandlerMapping getHandlerMapping() {
        if (this.registrations.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, ResourceWebHandler> urlMap = new LinkedHashMap<String, ResourceWebHandler>();
        for (ResourceHandlerRegistration registration : this.registrations) {
            for (String pathPattern : registration.getPathPatterns()) {
                ResourceWebHandler handler = registration.getRequestHandler();
                handler.setContentTypeResolver(this.contentTypeResolver);
                try {
                    handler.afterPropertiesSet();
                    handler.afterSingletonsInstantiated();
                }
                catch (Exception ex) {
                    throw new BeanInitializationException("Failed to init ResourceHttpRequestHandler", (Throwable)ex);
                }
                urlMap.put(pathPattern, handler);
            }
        }
        SimpleUrlHandlerMapping handlerMapping = new SimpleUrlHandlerMapping();
        handlerMapping.setOrder(this.order);
        handlerMapping.setUrlMap(urlMap);
        return handlerMapping;
    }
}

