/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.accept;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.web.reactive.accept.MappingContentTypeResolver;
import org.springframework.web.reactive.accept.RequestedContentTypeResolver;
import org.springframework.web.server.NotAcceptableStatusException;
import org.springframework.web.server.ServerWebExchange;

public class CompositeContentTypeResolver
implements MappingContentTypeResolver {
    private final List<RequestedContentTypeResolver> resolvers = new ArrayList<RequestedContentTypeResolver>();

    public CompositeContentTypeResolver(List<RequestedContentTypeResolver> resolvers) {
        Assert.notEmpty(resolvers, (String)"At least one resolver is expected.");
        this.resolvers.addAll(resolvers);
    }

    public List<RequestedContentTypeResolver> getResolvers() {
        return Collections.unmodifiableList(this.resolvers);
    }

    public <T extends RequestedContentTypeResolver> T findResolver(Class<T> resolverType) {
        for (RequestedContentTypeResolver resolver : this.resolvers) {
            if (!resolverType.isInstance(resolver)) continue;
            return (T)resolver;
        }
        return null;
    }

    @Override
    public List<MediaType> resolveMediaTypes(ServerWebExchange exchange) throws NotAcceptableStatusException {
        for (RequestedContentTypeResolver resolver : this.resolvers) {
            List<MediaType> mediaTypes = resolver.resolveMediaTypes(exchange);
            if (mediaTypes.isEmpty() || mediaTypes.size() == 1 && mediaTypes.contains(MediaType.ALL)) continue;
            return mediaTypes;
        }
        return Collections.emptyList();
    }

    @Override
    public Set<String> getKeysFor(MediaType mediaType) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (RequestedContentTypeResolver resolver : this.resolvers) {
            if (!(resolver instanceof MappingContentTypeResolver)) continue;
            result.addAll(((MappingContentTypeResolver)resolver).getKeysFor(mediaType));
        }
        return result;
    }

    @Override
    public Set<String> getKeys() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (RequestedContentTypeResolver resolver : this.resolvers) {
            if (!(resolver instanceof MappingContentTypeResolver)) continue;
            result.addAll(((MappingContentTypeResolver)resolver).getKeys());
        }
        return result;
    }
}

