/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive;

import java.util.Optional;
import java.util.function.Function;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.ui.ExtendedModelMap;
import org.springframework.ui.ModelMap;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class HandlerResult {
    private final Object handler;
    private final Optional<Object> returnValue;
    private final ResolvableType returnType;
    private final ModelMap model;
    private Function<Throwable, Mono<HandlerResult>> exceptionHandler;

    public HandlerResult(Object handler, Object returnValue, MethodParameter returnType) {
        this(handler, returnValue, returnType, null);
    }

    public HandlerResult(Object handler, Object returnValue, MethodParameter returnType, ModelMap model) {
        Assert.notNull((Object)handler, (String)"'handler' is required");
        Assert.notNull((Object)returnType, (String)"'returnType' is required");
        this.handler = handler;
        this.returnValue = Optional.ofNullable(returnValue);
        this.returnType = ResolvableType.forMethodParameter((MethodParameter)returnType);
        this.model = model != null ? model : new ExtendedModelMap();
    }

    public Object getHandler() {
        return this.handler;
    }

    public Optional<Object> getReturnValue() {
        return this.returnValue;
    }

    public ResolvableType getReturnType() {
        return this.returnType;
    }

    public MethodParameter getReturnTypeSource() {
        return (MethodParameter)this.returnType.getSource();
    }

    public ModelMap getModel() {
        return this.model;
    }

    public HandlerResult setExceptionHandler(Function<Throwable, Mono<HandlerResult>> function) {
        this.exceptionHandler = function;
        return this;
    }

    public boolean hasExceptionHandler() {
        return this.exceptionHandler != null;
    }

    public Mono<HandlerResult> applyExceptionHandler(Throwable failure) {
        return this.hasExceptionHandler() ? this.exceptionHandler.apply(failure) : Mono.error((Throwable)failure);
    }
}

