/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.view;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.http.MediaType;
import org.springframework.ui.ModelMap;
import org.springframework.util.Assert;
import org.springframework.web.reactive.HandlerResult;
import org.springframework.web.reactive.result.view.View;
import org.springframework.web.reactive.result.view.ViewResolverSupport;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public abstract class AbstractView
implements View,
ApplicationContextAware {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final List<MediaType> mediaTypes = new ArrayList<MediaType>(4);
    private ApplicationContext applicationContext;

    public AbstractView() {
        this.mediaTypes.add(ViewResolverSupport.DEFAULT_CONTENT_TYPE);
    }

    public void setSupportedMediaTypes(List<MediaType> supportedMediaTypes) {
        Assert.notEmpty(supportedMediaTypes, (String)"'supportedMediaTypes' is required.");
        this.mediaTypes.clear();
        if (supportedMediaTypes != null) {
            this.mediaTypes.addAll(supportedMediaTypes);
        }
    }

    @Override
    public List<MediaType> getSupportedMediaTypes() {
        return this.mediaTypes;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Override
    public Mono<Void> render(HandlerResult result, MediaType contentType, ServerWebExchange exchange) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Rendering view with model " + result.getModel()));
        }
        if (contentType != null) {
            exchange.getResponse().getHeaders().setContentType(contentType);
        }
        Map<String, Object> mergedModel = this.getModelAttributes(result, exchange);
        return this.renderInternal(mergedModel, exchange);
    }

    protected Map<String, Object> getModelAttributes(HandlerResult result, ServerWebExchange exchange) {
        ModelMap model = result.getModel();
        int size = model != null ? model.size() : 0;
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>(size);
        if (model != null) {
            attributes.putAll((Map<String, Object>)model);
        }
        return attributes;
    }

    protected abstract Mono<Void> renderInternal(Map<String, Object> var1, ServerWebExchange var2);

    public String toString() {
        return this.getClass().getName();
    }
}

