/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.util.Map;
import org.springframework.core.MethodParameter;
import org.springframework.ui.ModelMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.reactive.result.method.HandlerMethodArgumentResolver;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class RequestParamMapMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        RequestParam requestParam = (RequestParam)parameter.getParameterAnnotation(RequestParam.class);
        if (requestParam != null && Map.class.isAssignableFrom(parameter.getParameterType())) {
            return !StringUtils.hasText((String)requestParam.name());
        }
        return false;
    }

    @Override
    public Mono<Object> resolveArgument(MethodParameter parameter, ModelMap model, ServerWebExchange exchange) {
        Class paramType = parameter.getParameterType();
        MultiValueMap queryParams = exchange.getRequest().getQueryParams();
        if (MultiValueMap.class.isAssignableFrom(paramType)) {
            return Mono.just((Object)queryParams);
        }
        return Mono.just((Object)queryParams.toSingleValueMap());
    }
}

