/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.codec.ByteBufferDecoder;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.StringDecoder;
import org.springframework.core.convert.ConversionService;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.http.codec.DecoderHttpMessageReader;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.ui.ExtendedModelMap;
import org.springframework.ui.ModelMap;
import org.springframework.validation.Validator;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.method.annotation.ExceptionHandlerMethodResolver;
import org.springframework.web.reactive.HandlerAdapter;
import org.springframework.web.reactive.HandlerResult;
import org.springframework.web.reactive.result.method.HandlerMethodArgumentResolver;
import org.springframework.web.reactive.result.method.InvocableHandlerMethod;
import org.springframework.web.reactive.result.method.annotation.CookieValueMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.ExpressionValueMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.HttpEntityArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.ModelArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.PathVariableMapMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.PathVariableMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.RequestAttributeMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.RequestBodyArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.RequestHeaderMapMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.RequestHeaderMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.RequestParamMapMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.RequestParamMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.SessionAttributeMethodArgumentResolver;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class RequestMappingHandlerAdapter
implements HandlerAdapter,
BeanFactoryAware,
InitializingBean {
    private static Log logger = LogFactory.getLog(RequestMappingHandlerAdapter.class);
    private List<HandlerMethodArgumentResolver> customArgumentResolvers;
    private List<HandlerMethodArgumentResolver> argumentResolvers;
    private final List<HttpMessageReader<?>> messageReaders = new ArrayList(10);
    private ReactiveAdapterRegistry reactiveAdapters = new ReactiveAdapterRegistry();
    private ConversionService conversionService = new DefaultFormattingConversionService();
    private Validator validator;
    private ConfigurableBeanFactory beanFactory;
    private final Map<Class<?>, ExceptionHandlerMethodResolver> exceptionHandlerCache = new ConcurrentHashMap(64);

    public RequestMappingHandlerAdapter() {
        this.messageReaders.add((HttpMessageReader<?>)new DecoderHttpMessageReader((Decoder)new ByteBufferDecoder()));
        this.messageReaders.add((HttpMessageReader<?>)new DecoderHttpMessageReader((Decoder)new StringDecoder()));
    }

    public void setCustomArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        this.customArgumentResolvers = argumentResolvers;
    }

    public List<HandlerMethodArgumentResolver> getCustomArgumentResolvers() {
        return this.customArgumentResolvers;
    }

    public void setArgumentResolvers(List<HandlerMethodArgumentResolver> resolvers) {
        this.argumentResolvers = new ArrayList<HandlerMethodArgumentResolver>(resolvers);
    }

    public List<HandlerMethodArgumentResolver> getArgumentResolvers() {
        return this.argumentResolvers;
    }

    public void setMessageReaders(List<HttpMessageReader<?>> messageReaders) {
        this.messageReaders.clear();
        this.messageReaders.addAll(messageReaders);
    }

    public List<HttpMessageReader<?>> getMessageReaders() {
        return this.messageReaders;
    }

    public void setReactiveAdapterRegistry(ReactiveAdapterRegistry registry) {
        this.reactiveAdapters = registry;
    }

    public ReactiveAdapterRegistry getReactiveAdapterRegistry() {
        return this.reactiveAdapters;
    }

    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    public Validator getValidator() {
        return this.validator;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (beanFactory instanceof ConfigurableBeanFactory) {
            this.beanFactory = (ConfigurableBeanFactory)beanFactory;
        }
    }

    public ConfigurableBeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.argumentResolvers == null) {
            this.argumentResolvers = this.initArgumentResolvers();
        }
    }

    protected List<HandlerMethodArgumentResolver> initArgumentResolvers() {
        ArrayList<HandlerMethodArgumentResolver> resolvers = new ArrayList<HandlerMethodArgumentResolver>();
        ConversionService cs = this.getConversionService();
        ReactiveAdapterRegistry adapterRegistry = this.getReactiveAdapterRegistry();
        resolvers.add(new RequestParamMethodArgumentResolver(cs, this.getBeanFactory(), false));
        resolvers.add(new RequestParamMapMethodArgumentResolver());
        resolvers.add(new PathVariableMethodArgumentResolver(cs, this.getBeanFactory()));
        resolvers.add(new PathVariableMapMethodArgumentResolver());
        resolvers.add(new RequestBodyArgumentResolver(this.getMessageReaders(), this.getValidator(), adapterRegistry));
        resolvers.add(new RequestHeaderMethodArgumentResolver(cs, this.getBeanFactory()));
        resolvers.add(new RequestHeaderMapMethodArgumentResolver());
        resolvers.add(new CookieValueMethodArgumentResolver(cs, this.getBeanFactory()));
        resolvers.add(new ExpressionValueMethodArgumentResolver(cs, this.getBeanFactory()));
        resolvers.add(new SessionAttributeMethodArgumentResolver(cs, this.getBeanFactory()));
        resolvers.add(new RequestAttributeMethodArgumentResolver(cs, this.getBeanFactory()));
        resolvers.add(new HttpEntityArgumentResolver(this.getMessageReaders(), this.getValidator(), adapterRegistry));
        resolvers.add(new ModelArgumentResolver());
        if (this.getCustomArgumentResolvers() != null) {
            resolvers.addAll(this.getCustomArgumentResolvers());
        }
        resolvers.add(new RequestParamMethodArgumentResolver(cs, this.getBeanFactory(), true));
        return resolvers;
    }

    @Override
    public boolean supports(Object handler) {
        return HandlerMethod.class.equals(handler.getClass());
    }

    @Override
    public Mono<HandlerResult> handle(ServerWebExchange exchange, Object handler) {
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        InvocableHandlerMethod invocable = new InvocableHandlerMethod(handlerMethod);
        invocable.setHandlerMethodArgumentResolvers(this.getArgumentResolvers());
        ExtendedModelMap model = new ExtendedModelMap();
        return invocable.invokeForRequest(exchange, (ModelMap)model, new Object[0]).map(result -> result.setExceptionHandler(ex -> this.handleException((Throwable)ex, handlerMethod, exchange))).otherwise(ex -> this.handleException((Throwable)ex, handlerMethod, exchange));
    }

    private Mono<HandlerResult> handleException(Throwable ex, HandlerMethod handlerMethod, ServerWebExchange exchange) {
        block4: {
            InvocableHandlerMethod invocable;
            if (ex instanceof Exception && (invocable = this.findExceptionHandler(handlerMethod, (Exception)ex)) != null) {
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Invoking @ExceptionHandler method: " + (Object)((Object)invocable)));
                    }
                    invocable.setHandlerMethodArgumentResolvers(this.getArgumentResolvers());
                    ExtendedModelMap errorModel = new ExtendedModelMap();
                    return invocable.invokeForRequest(exchange, (ModelMap)errorModel, ex);
                }
                catch (Exception invocationEx) {
                    if (!logger.isErrorEnabled()) break block4;
                    logger.error((Object)("Failed to invoke @ExceptionHandler method: " + (Object)((Object)invocable)), (Throwable)invocationEx);
                }
            }
        }
        return Mono.error((Throwable)ex);
    }

    protected InvocableHandlerMethod findExceptionHandler(HandlerMethod handlerMethod, Exception exception) {
        Method method;
        if (handlerMethod == null) {
            return null;
        }
        Class handlerType = handlerMethod.getBeanType();
        ExceptionHandlerMethodResolver resolver = this.exceptionHandlerCache.get(handlerType);
        if (resolver == null) {
            resolver = new ExceptionHandlerMethodResolver(handlerType);
            this.exceptionHandlerCache.put(handlerType, resolver);
        }
        return (method = resolver.resolveMethod(exception)) != null ? new InvocableHandlerMethod(handlerMethod.getBean(), method) : null;
    }
}

