/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.util.List;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.ResolvableType;
import org.springframework.http.MediaType;
import org.springframework.http.ReactiveHttpOutputMessage;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.web.reactive.accept.RequestedContentTypeResolver;
import org.springframework.web.reactive.result.ContentNegotiatingResultHandlerSupport;
import org.springframework.web.server.NotAcceptableStatusException;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public abstract class AbstractMessageWriterResultHandler
extends ContentNegotiatingResultHandlerSupport {
    private final List<HttpMessageWriter<?>> messageWriters;

    protected AbstractMessageWriterResultHandler(List<HttpMessageWriter<?>> messageWriters, RequestedContentTypeResolver contentTypeResolver) {
        super(contentTypeResolver);
        Assert.notEmpty(messageWriters, (String)"At least one message writer is required.");
        this.messageWriters = messageWriters;
    }

    protected AbstractMessageWriterResultHandler(List<HttpMessageWriter<?>> messageWriters, RequestedContentTypeResolver contentTypeResolver, ReactiveAdapterRegistry adapterRegistry) {
        super(contentTypeResolver, adapterRegistry);
        Assert.notEmpty(messageWriters, (String)"At least one message writer is required.");
        this.messageWriters = messageWriters;
    }

    public List<HttpMessageWriter<?>> getMessageWriters() {
        return this.messageWriters;
    }

    protected Mono<Void> writeBody(Object body, MethodParameter bodyType, ServerWebExchange exchange) {
        ResolvableType elementType;
        Mono publisher;
        Class bodyClass = bodyType.getParameterType();
        ReactiveAdapter adapter = this.getAdapterRegistry().getAdapterFrom(bodyClass, body);
        if (adapter != null) {
            publisher = adapter.toPublisher(body);
            elementType = adapter.getDescriptor().isNoValue() ? ResolvableType.forClass(Void.class) : ResolvableType.forMethodParameter((MethodParameter)bodyType).getGeneric(new int[]{0});
        } else {
            publisher = Mono.justOrEmpty((Object)body);
            elementType = ResolvableType.forMethodParameter((MethodParameter)bodyType);
        }
        if (Void.TYPE == elementType.getRawClass() || Void.class == elementType.getRawClass()) {
            return Mono.from((Publisher)publisher);
        }
        List<MediaType> producibleTypes = this.getProducibleMediaTypes(elementType);
        if (producibleTypes.isEmpty()) {
            return Mono.error((Throwable)new IllegalStateException("No converter for return value type: " + elementType));
        }
        MediaType bestMediaType = this.selectMediaType(exchange, producibleTypes);
        if (bestMediaType != null) {
            for (HttpMessageWriter<?> messageWriter : this.getMessageWriters()) {
                if (!messageWriter.canWrite(elementType, bestMediaType)) continue;
                ServerHttpResponse response = exchange.getResponse();
                return messageWriter.write((Publisher)publisher, elementType, bestMediaType, (ReactiveHttpOutputMessage)response);
            }
        }
        return Mono.error((Throwable)new NotAcceptableStatusException(producibleTypes));
    }

    private List<MediaType> getProducibleMediaTypes(ResolvableType elementType) {
        return this.getMessageWriters().stream().filter(converter -> converter.canWrite(elementType, null)).flatMap(converter -> converter.getWritableMediaTypes().stream()).collect(Collectors.toList());
    }
}

