/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.springframework.core.Conventions;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.MediaType;
import org.springframework.http.ReactiveHttpInputMessage;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.SmartValidator;
import org.springframework.validation.Validator;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.ServerWebInputException;
import org.springframework.web.server.UnsupportedMediaTypeStatusException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class AbstractMessageReaderArgumentResolver {
    private final List<HttpMessageReader<?>> messageReaders;
    private final Validator validator;
    private final ReactiveAdapterRegistry adapterRegistry;
    private final List<MediaType> supportedMediaTypes;

    protected AbstractMessageReaderArgumentResolver(List<HttpMessageReader<?>> readers, Validator validator) {
        this(readers, validator, new ReactiveAdapterRegistry());
    }

    protected AbstractMessageReaderArgumentResolver(List<HttpMessageReader<?>> messageReaders, Validator validator, ReactiveAdapterRegistry adapterRegistry) {
        Assert.notEmpty(messageReaders, (String)"At least one HttpMessageReader is required.");
        Assert.notNull((Object)adapterRegistry, (String)"'adapterRegistry' is required");
        this.messageReaders = messageReaders;
        this.validator = validator;
        this.adapterRegistry = adapterRegistry;
        this.supportedMediaTypes = messageReaders.stream().flatMap(converter -> converter.getReadableMediaTypes().stream()).collect(Collectors.toList());
    }

    public List<HttpMessageReader<?>> getMessageReaders() {
        return this.messageReaders;
    }

    public ReactiveAdapterRegistry getAdapterRegistry() {
        return this.adapterRegistry;
    }

    protected Mono<Object> readBody(MethodParameter bodyParameter, boolean isBodyRequired, ServerWebExchange exchange) {
        ServerHttpRequest request;
        MediaType mediaType;
        Class bodyType = ResolvableType.forMethodParameter((MethodParameter)bodyParameter).resolve();
        ReactiveAdapter adapter = this.getAdapterRegistry().getAdapterTo(bodyType);
        ResolvableType elementType = ResolvableType.forMethodParameter((MethodParameter)bodyParameter);
        if (adapter != null) {
            elementType = elementType.getGeneric(new int[]{0});
        }
        if ((mediaType = (request = exchange.getRequest()).getHeaders().getContentType()) == null) {
            mediaType = MediaType.APPLICATION_OCTET_STREAM;
        }
        for (HttpMessageReader<?> reader : this.getMessageReaders()) {
            if (!reader.canRead(elementType, mediaType)) continue;
            if (adapter != null && adapter.getDescriptor().isMultiValue()) {
                Flux flux = reader.read(elementType, (ReactiveHttpInputMessage)request).onErrorResumeWith(ex -> Flux.error((Throwable)this.getReadError((Throwable)ex, bodyParameter)));
                if (this.checkRequired(adapter, isBodyRequired)) {
                    flux = flux.switchIfEmpty((Publisher)Flux.error((Throwable)this.getRequiredBodyError(bodyParameter)));
                }
                if (this.validator != null) {
                    flux = flux.map(this.applyValidationIfApplicable(bodyParameter));
                }
                return Mono.just((Object)adapter.fromPublisher((Publisher)flux));
            }
            Mono mono = reader.readMono(elementType, (ReactiveHttpInputMessage)request).otherwise(ex -> Mono.error((Throwable)this.getReadError((Throwable)ex, bodyParameter)));
            if (this.checkRequired(adapter, isBodyRequired)) {
                mono = mono.otherwiseIfEmpty(Mono.error((Throwable)this.getRequiredBodyError(bodyParameter)));
            }
            if (this.validator != null) {
                mono = mono.map(this.applyValidationIfApplicable(bodyParameter));
            }
            if (adapter != null) {
                return Mono.just((Object)adapter.fromPublisher((Publisher)mono));
            }
            return Mono.from((Publisher)mono);
        }
        return Mono.error((Throwable)new UnsupportedMediaTypeStatusException(mediaType, this.supportedMediaTypes));
    }

    protected boolean checkRequired(ReactiveAdapter adapter, boolean isBodyRequired) {
        return adapter != null && !adapter.getDescriptor().supportsEmpty() || isBodyRequired;
    }

    protected ServerWebInputException getReadError(Throwable ex, MethodParameter parameter) {
        return new ServerWebInputException("Failed to read HTTP message", parameter, ex);
    }

    protected ServerWebInputException getRequiredBodyError(MethodParameter parameter) {
        return new ServerWebInputException("Required request body is missing: " + parameter.getMethod().toGenericString());
    }

    protected <T> Function<T, T> applyValidationIfApplicable(MethodParameter methodParam) {
        Annotation[] annotations;
        for (Annotation ann : annotations = methodParam.getParameterAnnotations()) {
            Object[] objectArray;
            Object hints;
            Validated validAnnot = (Validated)AnnotationUtils.getAnnotation((Annotation)ann, Validated.class);
            if (validAnnot == null && !ann.annotationType().getSimpleName().startsWith("Valid")) continue;
            Object object = hints = validAnnot != null ? validAnnot.value() : AnnotationUtils.getValue((Annotation)ann);
            if (hints instanceof Object[]) {
                objectArray = hints;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = hints;
            }
            Object[] validHints = objectArray;
            return element -> {
                this.doValidate(element, validHints, methodParam);
                return element;
            };
        }
        return element -> element;
    }

    private void doValidate(Object target, Object[] validationHints, MethodParameter methodParam) {
        String name = Conventions.getVariableNameForParameter((MethodParameter)methodParam);
        BeanPropertyBindingResult errors = new BeanPropertyBindingResult(target, name);
        if (!ObjectUtils.isEmpty((Object[])validationHints) && this.validator instanceof SmartValidator) {
            ((SmartValidator)this.validator).validate(target, (Errors)errors, validationHints);
        } else if (this.validator != null) {
            this.validator.validate(target, (Errors)errors);
        }
        if (errors.hasErrors()) {
            throw new ServerWebInputException("Validation failed", methodParam);
        }
    }
}

