/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.ui.ModelMap;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.reactive.HandlerResult;
import org.springframework.web.reactive.result.method.HandlerMethodArgumentResolver;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class InvocableHandlerMethod
extends HandlerMethod {
    private static final Mono<Object[]> NO_ARGS = Mono.just((Object)new Object[0]);
    private static final Object NO_VALUE = new Object();
    private List<HandlerMethodArgumentResolver> resolvers = new ArrayList<HandlerMethodArgumentResolver>();
    private ParameterNameDiscoverer parameterNameDiscoverer = new DefaultParameterNameDiscoverer();

    public InvocableHandlerMethod(HandlerMethod handlerMethod) {
        super(handlerMethod);
    }

    public InvocableHandlerMethod(Object bean, Method method) {
        super(bean, method);
    }

    public void setHandlerMethodArgumentResolvers(List<HandlerMethodArgumentResolver> resolvers) {
        this.resolvers.clear();
        this.resolvers.addAll(resolvers);
    }

    protected Method getBridgedMethod() {
        return super.getBridgedMethod();
    }

    public Mono<HandlerResult> invokeForRequest(ServerWebExchange exchange, ModelMap model, Object ... providedArgs) {
        return this.resolveArguments(exchange, model, providedArgs).then(args -> {
            try {
                Object value = this.doInvoke((Object[])args);
                HandlerResult handlerResult = new HandlerResult((Object)this, value, this.getReturnType(), model);
                return Mono.just((Object)handlerResult);
            }
            catch (InvocationTargetException ex) {
                return Mono.error((Throwable)ex.getTargetException());
            }
            catch (Throwable ex) {
                String s = this.getInvocationErrorMessage((Object[])args);
                return Mono.error((Throwable)new IllegalStateException(s));
            }
        });
    }

    private Mono<Object[]> resolveArguments(ServerWebExchange exchange, ModelMap model, Object ... providedArgs) {
        if (ObjectUtils.isEmpty((Object[])this.getMethodParameters())) {
            return NO_ARGS;
        }
        try {
            List monos = Stream.of(this.getMethodParameters()).map(param -> {
                param.initParameterNameDiscovery(this.parameterNameDiscoverer);
                GenericTypeResolver.resolveParameterType((MethodParameter)param, this.getBean().getClass());
                if (!ObjectUtils.isEmpty((Object[])providedArgs)) {
                    for (Object providedArg : providedArgs) {
                        if (!param.getParameterType().isInstance(providedArg)) continue;
                        return Mono.just((Object)providedArg).log("reactor.resolved");
                    }
                }
                HandlerMethodArgumentResolver resolver = this.resolvers.stream().filter(r -> r.supportsParameter((MethodParameter)param)).findFirst().orElseThrow(() -> this.getArgError("No resolver for ", (MethodParameter)param, null));
                try {
                    return resolver.resolveArgument((MethodParameter)param, model, exchange).defaultIfEmpty(NO_VALUE).otherwise(ex -> Mono.error((Throwable)this.getArgError("Error resolving ", (MethodParameter)param, (Throwable)ex))).log("reactor.unresolved");
                }
                catch (Exception ex2) {
                    throw this.getArgError("Error resolving ", (MethodParameter)param, ex2);
                }
            }).collect(Collectors.toList());
            return Mono.when(monos).log("reactor.unresolved").map(args -> Stream.of(args).map(o -> o != NO_VALUE ? o : null).toArray());
        }
        catch (Throwable ex) {
            return Mono.error((Throwable)ex);
        }
    }

    private IllegalStateException getArgError(String message, MethodParameter param, Throwable cause) {
        return new IllegalStateException(message + "argument [" + param.getParameterIndex() + "] " + "of type [" + param.getParameterType().getName() + "] " + "on method [" + this.getBridgedMethod().toGenericString() + "]", cause);
    }

    private Object doInvoke(Object[] args) throws Exception {
        if (this.logger.isTraceEnabled()) {
            String target = this.getBeanType().getSimpleName() + "." + this.getMethod().getName();
            this.logger.trace((Object)("Invoking [" + target + "] method with arguments " + Arrays.toString(args)));
        }
        ReflectionUtils.makeAccessible((Method)this.getBridgedMethod());
        Object returnValue = this.getBridgedMethod().invoke(this.getBean(), args);
        if (this.logger.isTraceEnabled()) {
            String target = this.getBeanType().getSimpleName() + "." + this.getMethod().getName();
            this.logger.trace((Object)("Method [" + target + "] returned [" + returnValue + "]"));
        }
        return returnValue;
    }

    private String getInvocationErrorMessage(Object[] args) {
        String argumentDetails = IntStream.range(0, args.length).mapToObj(i -> args[i] != null ? "[" + i + "][type=" + args[i].getClass().getName() + "][value=" + args[i] + "]" : "[" + i + "][null]").collect(Collectors.joining(",", " ", " "));
        return "Failed to invoke controller with resolved arguments:" + argumentDetails + "on method [" + this.getBridgedMethod().toGenericString() + "]";
    }
}

