/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.condition;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.web.reactive.result.condition.AbstractNameValueExpression;
import org.springframework.web.reactive.result.condition.AbstractRequestCondition;
import org.springframework.web.reactive.result.condition.NameValueExpression;
import org.springframework.web.server.ServerWebExchange;

public final class HeadersRequestCondition
extends AbstractRequestCondition<HeadersRequestCondition> {
    private final Set<HeaderExpression> expressions;

    public HeadersRequestCondition(String ... headers) {
        this(HeadersRequestCondition.parseExpressions(headers));
    }

    private HeadersRequestCondition(Collection<HeaderExpression> conditions) {
        this.expressions = Collections.unmodifiableSet(new LinkedHashSet<HeaderExpression>(conditions));
    }

    private static Collection<HeaderExpression> parseExpressions(String ... headers) {
        LinkedHashSet<HeaderExpression> expressions = new LinkedHashSet<HeaderExpression>();
        if (headers != null) {
            for (String header : headers) {
                HeaderExpression expr = new HeaderExpression(header);
                if ("Accept".equalsIgnoreCase(expr.name) || "Content-Type".equalsIgnoreCase(expr.name)) continue;
                expressions.add(expr);
            }
        }
        return expressions;
    }

    public Set<NameValueExpression<String>> getExpressions() {
        return new LinkedHashSet<NameValueExpression<String>>(this.expressions);
    }

    @Override
    protected Collection<HeaderExpression> getContent() {
        return this.expressions;
    }

    @Override
    protected String getToStringInfix() {
        return " && ";
    }

    @Override
    public HeadersRequestCondition combine(HeadersRequestCondition other) {
        LinkedHashSet<HeaderExpression> set = new LinkedHashSet<HeaderExpression>(this.expressions);
        set.addAll(other.expressions);
        return new HeadersRequestCondition(set);
    }

    @Override
    public HeadersRequestCondition getMatchingCondition(ServerWebExchange exchange) {
        for (HeaderExpression expression : this.expressions) {
            if (expression.match(exchange)) continue;
            return null;
        }
        return this;
    }

    @Override
    public int compareTo(HeadersRequestCondition other, ServerWebExchange exchange) {
        return other.expressions.size() - this.expressions.size();
    }

    static class HeaderExpression
    extends AbstractNameValueExpression<String> {
        public HeaderExpression(String expression) {
            super(expression);
        }

        @Override
        protected boolean isCaseSensitiveName() {
            return false;
        }

        @Override
        protected String parseValue(String valueExpression) {
            return valueExpression;
        }

        @Override
        protected boolean matchName(ServerWebExchange exchange) {
            return exchange.getRequest().getHeaders().get((Object)this.name) != null;
        }

        @Override
        protected boolean matchValue(ServerWebExchange exchange) {
            return ((String)this.value).equals(exchange.getRequest().getHeaders().getFirst(this.name));
        }
    }
}

