/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.accept;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.reactive.accept.AbstractMappingContentTypeResolver;
import org.springframework.web.reactive.accept.CompositeContentTypeResolver;
import org.springframework.web.reactive.accept.FixedContentTypeResolver;
import org.springframework.web.reactive.accept.HeaderContentTypeResolver;
import org.springframework.web.reactive.accept.ParameterContentTypeResolver;
import org.springframework.web.reactive.accept.PathExtensionContentTypeResolver;
import org.springframework.web.reactive.accept.RequestedContentTypeResolver;

public class RequestedContentTypeResolverBuilder {
    private boolean favorPathExtension = true;
    private boolean favorParameter = false;
    private boolean ignoreAcceptHeader = false;
    private Map<String, MediaType> mediaTypes = new HashMap<String, MediaType>();
    private boolean ignoreUnknownPathExtensions = true;
    private Boolean useJaf;
    private String parameterName = "format";
    private RequestedContentTypeResolver contentTypeResolver;

    public RequestedContentTypeResolverBuilder favorPathExtension(boolean favorPathExtension) {
        this.favorPathExtension = favorPathExtension;
        return this;
    }

    public RequestedContentTypeResolverBuilder mediaTypes(Map<String, MediaType> mediaTypes) {
        if (!CollectionUtils.isEmpty(mediaTypes)) {
            for (Map.Entry<String, MediaType> entry : mediaTypes.entrySet()) {
                String extension = entry.getKey().toLowerCase(Locale.ENGLISH);
                this.mediaTypes.put(extension, entry.getValue());
            }
        }
        return this;
    }

    public RequestedContentTypeResolverBuilder mediaType(String key, MediaType mediaType) {
        this.mediaTypes.put(key, mediaType);
        return this;
    }

    public RequestedContentTypeResolverBuilder ignoreUnknownPathExtensions(boolean ignore) {
        this.ignoreUnknownPathExtensions = ignore;
        return this;
    }

    public RequestedContentTypeResolverBuilder useJaf(boolean useJaf) {
        this.useJaf = useJaf;
        return this;
    }

    public RequestedContentTypeResolverBuilder favorParameter(boolean favorParameter) {
        this.favorParameter = favorParameter;
        return this;
    }

    public RequestedContentTypeResolverBuilder parameterName(String parameterName) {
        Assert.notNull((Object)parameterName, (String)"parameterName is required");
        this.parameterName = parameterName;
        return this;
    }

    public RequestedContentTypeResolverBuilder ignoreAcceptHeader(boolean ignoreAcceptHeader) {
        this.ignoreAcceptHeader = ignoreAcceptHeader;
        return this;
    }

    public RequestedContentTypeResolverBuilder defaultContentType(MediaType contentType) {
        this.contentTypeResolver = new FixedContentTypeResolver(contentType);
        return this;
    }

    public RequestedContentTypeResolverBuilder defaultContentTypeResolver(RequestedContentTypeResolver resolver) {
        this.contentTypeResolver = resolver;
        return this;
    }

    public RequestedContentTypeResolver build() {
        AbstractMappingContentTypeResolver resolver;
        ArrayList<RequestedContentTypeResolver> resolvers = new ArrayList<RequestedContentTypeResolver>();
        if (this.favorPathExtension) {
            resolver = new PathExtensionContentTypeResolver(this.mediaTypes);
            ((PathExtensionContentTypeResolver)resolver).setIgnoreUnknownExtensions(this.ignoreUnknownPathExtensions);
            if (this.useJaf != null) {
                ((PathExtensionContentTypeResolver)resolver).setUseJaf(this.useJaf);
            }
            resolvers.add(resolver);
        }
        if (this.favorParameter) {
            resolver = new ParameterContentTypeResolver(this.mediaTypes);
            ((ParameterContentTypeResolver)resolver).setParameterName(this.parameterName);
            resolvers.add(resolver);
        }
        if (!this.ignoreAcceptHeader) {
            resolvers.add(new HeaderContentTypeResolver());
        }
        if (this.contentTypeResolver != null) {
            resolvers.add(this.contentTypeResolver);
        }
        return new CompositeContentTypeResolver(resolvers);
    }
}

