/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.accept;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.web.reactive.accept.AbstractMappingContentTypeResolver;
import org.springframework.web.server.NotAcceptableStatusException;
import org.springframework.web.server.ServerWebExchange;

public class ParameterContentTypeResolver
extends AbstractMappingContentTypeResolver {
    private static final Log logger = LogFactory.getLog(ParameterContentTypeResolver.class);
    private String parameterName = "format";

    public ParameterContentTypeResolver(Map<String, MediaType> mediaTypes) {
        super(mediaTypes);
    }

    public void setParameterName(String parameterName) {
        Assert.notNull((Object)parameterName, (String)"parameterName is required");
        this.parameterName = parameterName;
    }

    public String getParameterName() {
        return this.parameterName;
    }

    @Override
    protected String extractKey(ServerWebExchange exchange) {
        return (String)exchange.getRequest().getQueryParams().getFirst((Object)this.getParameterName());
    }

    @Override
    protected void handleMatch(String mediaTypeKey, MediaType mediaType) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Requested media type is '" + mediaType + "' based on '" + this.getParameterName() + "'='" + mediaTypeKey + "'."));
        }
    }

    @Override
    protected MediaType handleNoMatch(String key) throws NotAcceptableStatusException {
        throw new NotAcceptableStatusException(this.getMediaTypes());
    }
}

