/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.client.match;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Source;
import org.apache.tomcat.util.http.fileupload.FileItem;
import org.apache.tomcat.util.http.fileupload.FileItemFactory;
import org.apache.tomcat.util.http.fileupload.FileUpload;
import org.apache.tomcat.util.http.fileupload.RequestContext;
import org.apache.tomcat.util.http.fileupload.UploadContext;
import org.apache.tomcat.util.http.fileupload.disk.DiskFileItemFactory;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jspecify.annotations.Nullable;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.mock.http.MockHttpInputMessage;
import org.springframework.mock.http.client.MockClientHttpRequest;
import org.springframework.test.json.JsonAssert;
import org.springframework.test.json.JsonComparator;
import org.springframework.test.json.JsonCompareMode;
import org.springframework.test.util.AssertionErrors;
import org.springframework.test.util.XmlExpectationsHelper;
import org.springframework.test.web.client.RequestMatcher;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StreamUtils;
import org.w3c.dom.Node;

public class ContentRequestMatchers {
    private static final Charset DEFAULT_MULTIPART_ENCODING = StandardCharsets.UTF_8;
    private final XmlExpectationsHelper xmlHelper = new XmlExpectationsHelper();

    protected ContentRequestMatchers() {
    }

    public RequestMatcher contentType(String expectedContentType) {
        return this.contentType(MediaType.parseMediaType((String)expectedContentType));
    }

    public RequestMatcher contentType(MediaType expectedContentType) {
        return request -> {
            MediaType actualContentType = request.getHeaders().getContentType();
            AssertionErrors.assertTrue("Content type not set", actualContentType != null);
            AssertionErrors.assertEquals("Content type", expectedContentType, actualContentType);
        };
    }

    public RequestMatcher contentTypeCompatibleWith(String contentType) {
        return this.contentTypeCompatibleWith(MediaType.parseMediaType((String)contentType));
    }

    public RequestMatcher contentTypeCompatibleWith(MediaType contentType) {
        return request -> {
            MediaType actualContentType = request.getHeaders().getContentType();
            AssertionErrors.assertTrue("Content type not set", actualContentType != null);
            if (actualContentType != null) {
                AssertionErrors.assertTrue("Content type [" + String.valueOf(actualContentType) + "] is not compatible with [" + String.valueOf(contentType) + "]", actualContentType.isCompatibleWith(contentType));
            }
        };
    }

    public RequestMatcher string(Matcher<? super String> matcher) {
        return request -> {
            MockClientHttpRequest mockRequest = (MockClientHttpRequest)request;
            MatcherAssert.assertThat((String)"Request content", (Object)mockRequest.getBodyAsString(), (Matcher)matcher);
        };
    }

    public RequestMatcher string(String expectedContent) {
        return request -> {
            MockClientHttpRequest mockRequest = (MockClientHttpRequest)request;
            AssertionErrors.assertEquals("Request content", expectedContent, mockRequest.getBodyAsString());
        };
    }

    public RequestMatcher bytes(byte[] expectedContent) {
        return request -> {
            MockClientHttpRequest mockRequest = (MockClientHttpRequest)request;
            AssertionErrors.assertEquals("Request content", expectedContent, mockRequest.getBodyAsBytes());
        };
    }

    public RequestMatcher formData(MultiValueMap<String, String> expected) {
        return this.formData(expected, true);
    }

    public RequestMatcher formDataContains(Map<String, String> expected) {
        LinkedMultiValueMap multiValueMap = new LinkedMultiValueMap(expected.size());
        expected.forEach((arg_0, arg_1) -> ((MultiValueMap)multiValueMap).add(arg_0, arg_1));
        return this.formData((MultiValueMap<String, String>)multiValueMap, false);
    }

    private RequestMatcher formData(MultiValueMap<String, String> expectedMap, boolean containsExactly) {
        return request -> {
            MockClientHttpRequest mockRequest = (MockClientHttpRequest)request;
            MockHttpInputMessage message = new MockHttpInputMessage(mockRequest.getBodyAsBytes());
            message.getHeaders().putAll(mockRequest.getHeaders());
            MultiValueMap actualMap = new FormHttpMessageConverter().read(null, (HttpInputMessage)message);
            if (containsExactly) {
                AssertionErrors.assertEquals("Form data", expectedMap, actualMap);
            } else {
                AssertionErrors.assertTrue("Form data " + String.valueOf(actualMap), expectedMap.size() <= actualMap.size());
                for (Map.Entry entry : expectedMap.entrySet()) {
                    String name = (String)entry.getKey();
                    List values = (List)entry.getValue();
                    AssertionErrors.assertTrue("No form parameter '" + name + "'", actualMap.get((Object)name) != null);
                    AssertionErrors.assertTrue("Parameter value count " + values.size(), values.size() <= ((List)actualMap.get((Object)name)).size());
                    for (int i = 0; i < values.size(); ++i) {
                        AssertionErrors.assertEquals("Form parameter", values.get(i), ((List)actualMap.get((Object)name)).get(i));
                    }
                }
            }
        };
    }

    public RequestMatcher multipartData(MultiValueMap<String, ?> expectedMap) {
        return this.multipartData(expectedMap, DEFAULT_MULTIPART_ENCODING, true);
    }

    public RequestMatcher multipartData(MultiValueMap<String, ?> expectedMap, Charset defaultCharset) {
        return this.multipartData(expectedMap, defaultCharset, true);
    }

    public RequestMatcher multipartDataContains(Map<String, ?> expectedMap) {
        LinkedMultiValueMap map = new LinkedMultiValueMap(expectedMap.size());
        expectedMap.forEach((arg_0, arg_1) -> ((MultiValueMap)map).add(arg_0, arg_1));
        return this.multipartData((MultiValueMap<String, ?>)map, DEFAULT_MULTIPART_ENCODING, false);
    }

    private RequestMatcher multipartData(MultiValueMap<String, ?> expectedMap, Charset defaultCharset, boolean containsExactly) {
        return request -> {
            MultiValueMap<String, ?> actualMap = MultipartHelper.parse((MockClientHttpRequest)request, defaultCharset);
            if (containsExactly) {
                AssertionErrors.assertEquals("Multipart request content: " + String.valueOf(actualMap), expectedMap.size(), actualMap.size());
            }
            for (Map.Entry entry : expectedMap.entrySet()) {
                String name = (String)entry.getKey();
                List values = (List)entry.getValue();
                AssertionErrors.assertTrue("No Multipart '" + name + "'", actualMap.get((Object)name) != null);
                AssertionErrors.assertTrue("Multipart value count " + values.size(), containsExactly ? values.size() == ((List)actualMap.get((Object)name)).size() : values.size() <= ((List)actualMap.get((Object)name)).size());
                for (int i = 0; i < values.size(); ++i) {
                    MediaType expectedContentType = null;
                    Object expected = values.get(i);
                    Object actual = ((List)actualMap.get((Object)name)).get(i);
                    if (expected instanceof HttpEntity) {
                        HttpEntity entity = (HttpEntity)expected;
                        expectedContentType = entity.getHeaders().getContentType();
                        expected = entity.getBody();
                    }
                    if (expected instanceof Resource) {
                        Resource resource = (Resource)expected;
                        expected = StreamUtils.copyToByteArray((InputStream)resource.getInputStream());
                    }
                    if (expected instanceof byte[]) {
                        AssertionErrors.assertEquals("Multipart content", expected, ContentRequestMatchers.asHttpEntity(actual).getBody());
                    } else if (expected instanceof String) {
                        AssertionErrors.assertTrue("Multipart is not a String", actual instanceof String);
                        AssertionErrors.assertEquals("Multipart content", expected, actual);
                    } else {
                        throw new IllegalArgumentException("Unexpected multipart value: " + String.valueOf(expected != null ? expected.getClass() : null));
                    }
                    if (expectedContentType == null) continue;
                    AssertionErrors.assertEquals("Multipart content-type", expectedContentType, ContentRequestMatchers.asHttpEntity(actual).getHeaders().getContentType());
                }
            }
        };
    }

    private static HttpEntity<byte[]> asHttpEntity(Object actual) {
        AssertionErrors.assertTrue("Multipart is not an HttpEntity", actual instanceof HttpEntity);
        return (HttpEntity)actual;
    }

    public RequestMatcher xml(final String expectedXmlContent) {
        return new AbstractXmlRequestMatcher(this){
            final /* synthetic */ ContentRequestMatchers this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            protected void matchInternal(MockClientHttpRequest request) throws Exception {
                this.this$0.xmlHelper.assertXmlEqual(expectedXmlContent, request.getBodyAsString());
            }
        };
    }

    public RequestMatcher node(final Matcher<? super Node> matcher) {
        return new AbstractXmlRequestMatcher(this){
            final /* synthetic */ ContentRequestMatchers this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            protected void matchInternal(MockClientHttpRequest request) throws Exception {
                this.this$0.xmlHelper.assertNode(request.getBodyAsString(), (Matcher<? super Node>)matcher);
            }
        };
    }

    public RequestMatcher source(final Matcher<? super Source> matcher) {
        return new AbstractXmlRequestMatcher(this){
            final /* synthetic */ ContentRequestMatchers this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            protected void matchInternal(MockClientHttpRequest request) throws Exception {
                this.this$0.xmlHelper.assertSource(request.getBodyAsString(), (Matcher<? super Source>)matcher);
            }
        };
    }

    public RequestMatcher json(String expectedJsonContent) {
        return this.json(expectedJsonContent, JsonCompareMode.LENIENT);
    }

    @Deprecated(since="6.2")
    public RequestMatcher json(String expectedJsonContent, boolean strict) {
        JsonCompareMode compareMode = strict ? JsonCompareMode.STRICT : JsonCompareMode.LENIENT;
        return this.json(expectedJsonContent, compareMode);
    }

    public RequestMatcher json(String expectedJsonContent, JsonCompareMode compareMode) {
        return this.json(expectedJsonContent, JsonAssert.comparator(compareMode));
    }

    public RequestMatcher json(String expectedJsonContent, JsonComparator comparator) {
        return request -> {
            try {
                MockClientHttpRequest mockRequest = (MockClientHttpRequest)request;
                comparator.assertIsMatch(expectedJsonContent, mockRequest.getBodyAsString());
            }
            catch (Exception ex) {
                throw new AssertionError("Failed to parse expected or actual JSON request content", ex);
            }
        };
    }

    private static class MultipartHelper {
        private MultipartHelper() {
        }

        public static MultiValueMap<String, ?> parse(final MockClientHttpRequest request, Charset defaultCharset) {
            try {
                FileUpload fileUpload = new FileUpload();
                DiskFileItemFactory factory = new DiskFileItemFactory();
                factory.setDefaultCharset(defaultCharset.name());
                fileUpload.setFileItemFactory((FileItemFactory)factory);
                List fileItems = fileUpload.parseRequest((RequestContext)new UploadContext(){
                    private final byte[] body;
                    {
                        this.body = request.getBodyAsBytes();
                    }

                    public @Nullable String getCharacterEncoding() {
                        return request.getHeaders().getFirst("Content-Encoding");
                    }

                    public @Nullable String getContentType() {
                        return request.getHeaders().getFirst("Content-Type");
                    }

                    public InputStream getInputStream() {
                        return new ByteArrayInputStream(this.body);
                    }

                    public long contentLength() {
                        return this.body.length;
                    }
                });
                LinkedMultiValueMap result = new LinkedMultiValueMap();
                for (FileItem fileItem : fileItems) {
                    result.add((Object)fileItem.getFieldName(), fileItem.isFormField() ? fileItem.getString() : MultipartHelper.toHttpEntity(fileItem));
                }
                return result;
            }
            catch (Exception ex) {
                throw new IllegalStateException("Failed to parse multipart request", ex);
            }
        }

        private static HttpEntity<?> toHttpEntity(FileItem fileItem) {
            HttpHeaders headers = new HttpHeaders();
            headers.set("Content-Type", fileItem.getContentType());
            return new HttpEntity((Object)fileItem.get(), headers);
        }
    }

    private static abstract class AbstractXmlRequestMatcher
    implements RequestMatcher {
        private AbstractXmlRequestMatcher() {
        }

        @Override
        public final void match(ClientHttpRequest request) throws IOException, AssertionError {
            try {
                MockClientHttpRequest mockRequest = (MockClientHttpRequest)request;
                this.matchInternal(mockRequest);
            }
            catch (Exception ex) {
                throw new AssertionError("Failed to parse expected or actual XML request content", ex);
            }
        }

        protected abstract void matchInternal(MockClientHttpRequest var1) throws Exception;
    }
}

