/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.client;

import java.io.IOException;
import java.util.Iterator;
import org.jspecify.annotations.Nullable;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.test.web.client.AbstractRequestExpectationManager;
import org.springframework.test.web.client.RequestExpectation;
import org.springframework.util.Assert;

public class SimpleRequestExpectationManager
extends AbstractRequestExpectationManager {
    private @Nullable Iterator<RequestExpectation> expectationIterator;
    private final AbstractRequestExpectationManager.RequestExpectationGroup repeatExpectations = new AbstractRequestExpectationManager.RequestExpectationGroup();

    @Override
    protected void afterExpectationsDeclared() {
        Assert.state((this.expectationIterator == null ? 1 : 0) != 0, (String)"Expectations already declared");
        this.expectationIterator = this.getExpectations().iterator();
    }

    @Override
    protected RequestExpectation matchRequest(ClientHttpRequest request) throws IOException {
        RequestExpectation expectation = this.repeatExpectations.findExpectation(request);
        if (expectation == null) {
            if (this.expectationIterator == null || !this.expectationIterator.hasNext()) {
                throw this.createUnexpectedRequestError(request);
            }
            expectation = this.expectationIterator.next();
            expectation.match(request);
        }
        this.repeatExpectations.update(expectation);
        return expectation;
    }

    @Override
    public void reset() {
        super.reset();
        this.expectationIterator = null;
        this.repeatExpectations.reset();
    }
}

