/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.bean.override;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.aop.scope.ScopedProxyUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.config.SingletonBeanRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.beans.factory.support.DefaultBeanNameGenerator;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.Ordered;
import org.springframework.core.ResolvableType;
import org.springframework.test.context.bean.override.BeanOverrideHandler;
import org.springframework.test.context.bean.override.BeanOverrideRegistry;
import org.springframework.util.Assert;

class BeanOverrideBeanFactoryPostProcessor
implements BeanFactoryPostProcessor,
Ordered {
    private static final String PSEUDO_BEAN_NAME_PLACEHOLDER = "<<< PSEUDO BEAN NAME PLACEHOLDER >>>";
    private static final BeanNameGenerator beanNameGenerator = DefaultBeanNameGenerator.INSTANCE;
    private final Set<BeanOverrideHandler> beanOverrideHandlers;
    private final BeanOverrideRegistry beanOverrideRegistry;

    BeanOverrideBeanFactoryPostProcessor(Set<BeanOverrideHandler> beanOverrideHandlers, BeanOverrideRegistry beanOverrideRegistry) {
        this.beanOverrideHandlers = beanOverrideHandlers;
        this.beanOverrideRegistry = beanOverrideRegistry;
    }

    public int getOrder() {
        return 0x7FFFFFF5;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        HashSet<String> generatedBeanNames = new HashSet<String>();
        for (BeanOverrideHandler handler : this.beanOverrideHandlers) {
            this.registerBeanOverride(beanFactory, handler, generatedBeanNames);
        }
    }

    private void registerBeanOverride(ConfigurableListableBeanFactory beanFactory, BeanOverrideHandler handler, Set<String> generatedBeanNames) {
        String beanName = handler.getBeanName();
        Assert.state((!BeanFactoryUtils.isFactoryDereference((String)beanName) ? 1 : 0) != 0, () -> "Unable to override bean '%s'%s: a FactoryBean cannot be overridden. To override the bean created by the FactoryBean, remove the '&' prefix.".formatted(beanName, BeanOverrideBeanFactoryPostProcessor.forField(handler.getField())));
        switch (handler.getStrategy()) {
            case REPLACE: {
                this.replaceOrCreateBean(beanFactory, handler, generatedBeanNames, true);
                break;
            }
            case REPLACE_OR_CREATE: {
                this.replaceOrCreateBean(beanFactory, handler, generatedBeanNames, false);
                break;
            }
            case WRAP: {
                this.wrapBean(beanFactory, handler);
            }
        }
    }

    private void replaceOrCreateBean(ConfigurableListableBeanFactory beanFactory, BeanOverrideHandler handler, Set<String> generatedBeanNames, boolean requireExistingBean) {
        String beanName = handler.getBeanName();
        BeanDefinition existingBeanDefinition = null;
        if (beanName == null) {
            beanName = BeanOverrideBeanFactoryPostProcessor.getBeanNameForType(beanFactory, handler, requireExistingBean);
            if (beanName != null && !generatedBeanNames.contains(beanName)) {
                if (beanFactory.containsBeanDefinition(beanName = BeanFactoryUtils.transformedBeanName((String)beanName))) {
                    existingBeanDefinition = beanFactory.getBeanDefinition(beanName);
                    BeanOverrideBeanFactoryPostProcessor.setQualifiedElement(existingBeanDefinition, handler);
                }
            } else {
                beanName = PSEUDO_BEAN_NAME_PLACEHOLDER;
            }
        } else {
            Set<String> candidates = BeanOverrideBeanFactoryPostProcessor.getExistingBeanNamesByType(beanFactory, handler, false);
            if (candidates.contains(beanName)) {
                existingBeanDefinition = beanFactory.getBeanDefinition(beanName);
                BeanOverrideBeanFactoryPostProcessor.setQualifiedElement(existingBeanDefinition, handler);
            } else if (requireExistingBean) {
                Field field = handler.getField();
                throw new IllegalStateException("Unable to replace bean: there is no bean with name '%s' and type %s%s. If the bean is defined in a @Bean method, make sure the return type is the most specific type possible (for example, the concrete implementation type).".formatted(beanName, handler.getBeanType(), BeanOverrideBeanFactoryPostProcessor.requiredByField(field)));
            }
        }
        if (existingBeanDefinition != null) {
            BeanOverrideBeanFactoryPostProcessor.validateBeanDefinition(beanFactory, beanName);
        } else if (!Boolean.getBoolean("spring.aot.processing")) {
            if (!(beanFactory instanceof BeanDefinitionRegistry)) {
                throw new IllegalStateException("Cannot process bean override with a BeanFactory that does not implement BeanDefinitionRegistry: " + beanFactory.getClass().getName());
            }
            BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
            RootBeanDefinition pseudoBeanDefinition = BeanOverrideBeanFactoryPostProcessor.createPseudoBeanDefinition(handler);
            if (PSEUDO_BEAN_NAME_PLACEHOLDER.equals(beanName)) {
                beanName = beanNameGenerator.generateBeanName((BeanDefinition)pseudoBeanDefinition, registry);
                generatedBeanNames.add(beanName);
            }
            registry.registerBeanDefinition(beanName, (BeanDefinition)pseudoBeanDefinition);
        }
        Object override = handler.createOverrideInstance(beanName, existingBeanDefinition, null, (SingletonBeanRegistry)beanFactory);
        this.beanOverrideRegistry.registerBeanOverrideHandler(handler, beanName);
        if (beanFactory.containsSingleton(beanName)) {
            BeanOverrideBeanFactoryPostProcessor.destroySingleton(beanFactory, beanName);
        }
        beanFactory.registerSingleton(beanName, override);
    }

    private void wrapBean(ConfigurableListableBeanFactory beanFactory, BeanOverrideHandler handler) {
        String beanName = handler.getBeanName();
        Field field = handler.getField();
        ResolvableType beanType = handler.getBeanType();
        if (beanName == null) {
            Set<String> candidateNames = BeanOverrideBeanFactoryPostProcessor.getExistingBeanNamesByType(beanFactory, handler, true);
            String uniqueCandidate = BeanOverrideBeanFactoryPostProcessor.determineUniqueCandidate(beanFactory, candidateNames, beanType, field);
            if (uniqueCandidate == null) {
                Object message = "Unable to select a bean to wrap: ";
                int candidateCount = candidateNames.size();
                message = candidateCount == 0 ? (String)message + "there are no beans of type %s%s. If the bean is defined in a @Bean method, make sure the return type is the most specific type possible (for example, the concrete implementation type).".formatted(beanType, BeanOverrideBeanFactoryPostProcessor.requiredByField(field)) : (String)message + "found %d beans of type %s%s: %s".formatted(candidateCount, beanType, BeanOverrideBeanFactoryPostProcessor.requiredByField(field), candidateNames);
                throw new IllegalStateException((String)message);
            }
            beanName = uniqueCandidate;
            beanName = BeanFactoryUtils.transformedBeanName((String)beanName);
        } else {
            Set<String> candidates = BeanOverrideBeanFactoryPostProcessor.getExistingBeanNamesByType(beanFactory, handler, false);
            if (!candidates.contains(beanName)) {
                throw new IllegalStateException("Unable to wrap bean: there is no bean with name '%s' and type %s%s. If the bean is defined in a @Bean method, make sure the return type is the most specific type possible (for example, the concrete implementation type).".formatted(beanName, beanType, BeanOverrideBeanFactoryPostProcessor.requiredByField(field)));
            }
        }
        BeanOverrideBeanFactoryPostProcessor.validateBeanDefinition(beanFactory, beanName);
        this.beanOverrideRegistry.registerBeanOverrideHandler(handler, beanName);
    }

    private static @Nullable String getBeanNameForType(ConfigurableListableBeanFactory beanFactory, BeanOverrideHandler handler, boolean requireExistingBean) {
        Field field = handler.getField();
        ResolvableType beanType = handler.getBeanType();
        Set<String> candidateNames = BeanOverrideBeanFactoryPostProcessor.getExistingBeanNamesByType(beanFactory, handler, true);
        String uniqueCandidate = BeanOverrideBeanFactoryPostProcessor.determineUniqueCandidate(beanFactory, candidateNames, beanType, field);
        if (uniqueCandidate != null) {
            return uniqueCandidate;
        }
        int candidateCount = candidateNames.size();
        if (candidateCount == 0) {
            if (requireExistingBean) {
                throw new IllegalStateException("Unable to override bean: there are no beans of type %s%s. If the bean is defined in a @Bean method, make sure the return type is the most specific type possible (for example, the concrete implementation type).".formatted(beanType, BeanOverrideBeanFactoryPostProcessor.requiredByField(field)));
            }
            return null;
        }
        throw new IllegalStateException("Unable to select a bean to override: found %d beans of type %s%s: %s".formatted(candidateCount, beanType, BeanOverrideBeanFactoryPostProcessor.requiredByField(field), candidateNames));
    }

    private static Set<String> getExistingBeanNamesByType(ConfigurableListableBeanFactory beanFactory, BeanOverrideHandler handler, boolean checkAutowiredCandidate) {
        Field field = handler.getField();
        ResolvableType resolvableType = handler.getBeanType();
        Class type = resolvableType.toClass();
        LinkedHashSet<String> beanNames = new LinkedHashSet<String>(Arrays.asList(beanFactory.getBeanNamesForType(resolvableType, true, false)));
        for (String beanName2 : beanFactory.getBeanNamesForType(FactoryBean.class, true, false)) {
            Class producedType = beanFactory.getType(beanName2 = BeanFactoryUtils.transformedBeanName((String)beanName2), false);
            if (!type.equals(producedType)) continue;
            beanNames.add(beanName2);
        }
        if (field != null && checkAutowiredCandidate) {
            DependencyDescriptor descriptor = new DependencyDescriptor(field, true);
            beanNames.removeIf(beanName -> !beanFactory.isAutowireCandidate(beanName, descriptor));
        }
        beanNames.removeIf(ScopedProxyUtils::isScopedTarget);
        return beanNames;
    }

    private static @Nullable String determineUniqueCandidate(ConfigurableListableBeanFactory beanFactory, Set<String> candidateNames, ResolvableType beanType, @Nullable Field field) {
        String fieldName;
        int candidateCount = candidateNames.size();
        if (candidateCount == 0) {
            return null;
        }
        if (candidateCount == 1) {
            return candidateNames.iterator().next();
        }
        String primaryCandidate = BeanOverrideBeanFactoryPostProcessor.determinePrimaryCandidate(beanFactory, candidateNames, beanType.toClass());
        if (primaryCandidate != null) {
            return primaryCandidate;
        }
        if (field != null && candidateNames.contains(fieldName = field.getName())) {
            return fieldName;
        }
        return null;
    }

    private static @Nullable String determinePrimaryCandidate(ConfigurableListableBeanFactory beanFactory, Set<String> candidateBeanNames, Class<?> beanType) {
        BeanDefinition beanDefinition;
        if (candidateBeanNames.isEmpty()) {
            return null;
        }
        String primaryBeanName = null;
        for (String candidateBeanName : candidateBeanNames) {
            if (!beanFactory.containsBeanDefinition(candidateBeanName) || !(beanDefinition = beanFactory.getBeanDefinition(candidateBeanName)).isPrimary()) continue;
            if (primaryBeanName != null) {
                throw new NoUniqueBeanDefinitionException(beanType, candidateBeanNames.size(), "more than one 'primary' bean found among candidates: " + String.valueOf(candidateBeanNames));
            }
            primaryBeanName = candidateBeanName;
        }
        if (primaryBeanName == null) {
            for (String candidateBeanName : candidateBeanNames) {
                if (!beanFactory.containsBeanDefinition(candidateBeanName) || (beanDefinition = beanFactory.getBeanDefinition(candidateBeanName)).isFallback()) continue;
                if (primaryBeanName != null) {
                    return null;
                }
                primaryBeanName = candidateBeanName;
            }
        }
        return primaryBeanName;
    }

    private static RootBeanDefinition createPseudoBeanDefinition(BeanOverrideHandler handler) {
        RootBeanDefinition definition = new RootBeanDefinition(handler.getBeanType().resolve());
        definition.setTargetType(handler.getBeanType());
        BeanOverrideBeanFactoryPostProcessor.setQualifiedElement((BeanDefinition)definition, handler);
        return definition;
    }

    private static void setQualifiedElement(BeanDefinition beanDefinition, BeanOverrideHandler handler) {
        Field field = handler.getField();
        if (field != null && beanDefinition instanceof RootBeanDefinition) {
            RootBeanDefinition rbd = (RootBeanDefinition)beanDefinition;
            rbd.setQualifiedElement((AnnotatedElement)field);
        }
    }

    private static void validateBeanDefinition(ConfigurableListableBeanFactory beanFactory, String beanName) {
        if (beanFactory.containsBeanDefinition(beanName)) {
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition(beanName);
            Assert.state((boolean)beanDefinition.isSingleton(), () -> "Unable to override bean '" + beanName + "': only singleton beans can be overridden.");
        }
    }

    private static void destroySingleton(ConfigurableListableBeanFactory beanFactory, String beanName) {
        if (!(beanFactory instanceof DefaultListableBeanFactory)) {
            throw new IllegalStateException("Cannot process bean override with a BeanFactory that does not implement DefaultListableBeanFactory: " + beanFactory.getClass().getName());
        }
        DefaultListableBeanFactory dlbf = (DefaultListableBeanFactory)beanFactory;
        dlbf.destroySingleton(beanName);
    }

    private static String forField(@Nullable Field field) {
        if (field == null) {
            return "";
        }
        return " for field '%s.%s'".formatted(field.getDeclaringClass().getSimpleName(), field.getName());
    }

    private static String requiredByField(@Nullable Field field) {
        if (field == null) {
            return "";
        }
        return " (as required by field '%s.%s')".formatted(field.getDeclaringClass().getSimpleName(), field.getName());
    }
}

