/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.bean.override.mockito;

import java.lang.reflect.Field;
import java.lang.reflect.Proxy;
import org.jspecify.annotations.Nullable;
import org.mockito.AdditionalAnswers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.listeners.VerificationStartedEvent;
import org.mockito.listeners.VerificationStartedListener;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.core.ResolvableType;
import org.springframework.test.context.bean.override.BeanOverrideStrategy;
import org.springframework.test.context.bean.override.mockito.AbstractMockitoBeanOverrideHandler;
import org.springframework.test.context.bean.override.mockito.MockReset;
import org.springframework.test.context.bean.override.mockito.MockitoSpyBean;
import org.springframework.test.context.bean.override.mockito.SpringMockResolver;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class MockitoSpyBeanOverrideHandler
extends AbstractMockitoBeanOverrideHandler {
    private static final VerificationStartedListener verificationStartedListener = new SpringAopBypassingVerificationStartedListener();

    MockitoSpyBeanOverrideHandler(Field field, ResolvableType typeToSpy, MockitoSpyBean spyBean) {
        super(field, typeToSpy, StringUtils.hasText((String)spyBean.name()) ? spyBean.name() : null, BeanOverrideStrategy.WRAP, spyBean.reset());
        Assert.notNull((Object)typeToSpy, (String)"typeToSpy must not be null");
    }

    @Override
    protected Object createOverrideInstance(String beanName, @Nullable BeanDefinition existingBeanDefinition, @Nullable Object existingBeanInstance) {
        Assert.notNull((Object)existingBeanInstance, () -> "@MockitoSpyBean requires an existing bean instance for bean " + beanName);
        return this.createSpy(beanName, existingBeanInstance);
    }

    private Object createSpy(String name, Object instance) {
        Class<?> toSpy;
        Class resolvedTypeToOverride = this.getBeanType().resolve();
        Assert.notNull((Object)resolvedTypeToOverride, (String)"Failed to resolve type to override");
        Assert.isInstanceOf((Class)resolvedTypeToOverride, (Object)instance);
        if (Mockito.mockingDetails((Object)instance).isSpy()) {
            return instance;
        }
        MockSettings settings = MockReset.withSettings(this.getReset());
        if (StringUtils.hasLength((String)name)) {
            settings.name(name);
        }
        if (SpringMockResolver.springAopPresent) {
            settings.verificationStartedListeners(new VerificationStartedListener[]{verificationStartedListener});
        }
        if (Proxy.isProxyClass(instance.getClass())) {
            settings.defaultAnswer(AdditionalAnswers.delegatesTo((Object)instance));
            toSpy = this.getBeanType().toClass();
        } else {
            settings.defaultAnswer(Mockito.CALLS_REAL_METHODS);
            settings.spiedInstance(instance);
            toSpy = instance.getClass();
        }
        return Mockito.mock(toSpy, (MockSettings)settings);
    }

    private static final class SpringAopBypassingVerificationStartedListener
    implements VerificationStartedListener {
        private SpringAopBypassingVerificationStartedListener() {
        }

        public void onVerificationStarted(VerificationStartedEvent event) {
            event.setMock(SpringMockResolver.getUltimateTargetObject(event.getMock()));
        }
    }
}

