/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.bean.override.mockito;

import java.util.Arrays;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.mockito.Mockito;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.bean.override.mockito.MockBeans;
import org.springframework.test.context.bean.override.mockito.MockReset;
import org.springframework.test.context.support.AbstractTestExecutionListener;
import org.springframework.util.ClassUtils;

public class MockitoResetTestExecutionListener
extends AbstractTestExecutionListener {
    private static final Log logger = LogFactory.getLog(MockitoResetTestExecutionListener.class);
    private static final boolean mockitoPresent = ClassUtils.isPresent((String)"org.mockito.Mockito", (ClassLoader)MockitoResetTestExecutionListener.class.getClassLoader());
    private static volatile @Nullable Boolean mockitoInitialized;

    @Override
    public int getOrder() {
        return 2147483547;
    }

    @Override
    public void beforeTestMethod(TestContext testContext) {
        if (MockitoResetTestExecutionListener.isEnabled()) {
            MockitoResetTestExecutionListener.resetMocks(testContext.getApplicationContext(), MockReset.BEFORE);
        }
    }

    @Override
    public void afterTestMethod(TestContext testContext) {
        if (MockitoResetTestExecutionListener.isEnabled()) {
            MockitoResetTestExecutionListener.resetMocks(testContext.getApplicationContext(), MockReset.AFTER);
        }
    }

    private static void resetMocks(ApplicationContext applicationContext, MockReset reset) {
        if (applicationContext instanceof ConfigurableApplicationContext) {
            ConfigurableApplicationContext configurableContext = (ConfigurableApplicationContext)applicationContext;
            MockitoResetTestExecutionListener.resetMocks(configurableContext, reset);
        }
    }

    private static void resetMocks(ConfigurableApplicationContext applicationContext, MockReset reset) {
        ConfigurableListableBeanFactory beanFactory = applicationContext.getBeanFactory();
        String[] beanNames = beanFactory.getBeanDefinitionNames();
        HashSet<String> instantiatedSingletons = new HashSet<String>(Arrays.asList(beanFactory.getSingletonNames()));
        for (String beanName : beanNames) {
            Object bean;
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition(beanName);
            if (!beanDefinition.isSingleton() || !instantiatedSingletons.contains(beanName) || (bean = MockitoResetTestExecutionListener.getBean(beanFactory, beanName)) == null || reset != MockReset.get(bean)) continue;
            Mockito.reset((Object[])new Object[]{bean});
        }
        try {
            ((MockBeans)beanFactory.getBean(MockBeans.class)).resetAll(reset);
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
        if (applicationContext.getParent() != null) {
            MockitoResetTestExecutionListener.resetMocks(applicationContext.getParent(), reset);
        }
    }

    private static @Nullable Object getBean(ConfigurableListableBeanFactory beanFactory, String beanName) {
        try {
            if (MockitoResetTestExecutionListener.isStandardBeanOrSingletonFactoryBean((BeanFactory)beanFactory, beanName)) {
                return beanFactory.getBean(beanName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return beanFactory.getSingleton(beanName);
    }

    private static boolean isStandardBeanOrSingletonFactoryBean(BeanFactory beanFactory, String beanName) {
        String factoryBeanName = "&" + beanName;
        if (beanFactory.containsBean(factoryBeanName)) {
            FactoryBean factoryBean = (FactoryBean)beanFactory.getBean(factoryBeanName);
            return factoryBean.isSingleton();
        }
        return true;
    }

    private static boolean isEnabled() {
        if (!mockitoPresent) {
            return false;
        }
        Boolean enabled = mockitoInitialized;
        if (enabled == null) {
            block4: {
                try {
                    Mockito.mockingDetails((Object)"a string is not a mock").isMock();
                    enabled = true;
                }
                catch (Throwable ex) {
                    enabled = false;
                    if (!logger.isDebugEnabled()) break block4;
                    logger.debug((Object)"MockitoResetTestExecutionListener is disabled in the current environment. See exception for details.", ex);
                }
            }
            mockitoInitialized = enabled;
        }
        return enabled;
    }
}

