/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.bean.override.mockito;

import java.lang.reflect.Field;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.config.SingletonBeanRegistry;
import org.springframework.core.ResolvableType;
import org.springframework.core.style.ToStringCreator;
import org.springframework.test.context.bean.override.BeanOverrideHandler;
import org.springframework.test.context.bean.override.BeanOverrideStrategy;
import org.springframework.test.context.bean.override.mockito.MockBeans;
import org.springframework.test.context.bean.override.mockito.MockReset;

abstract class AbstractMockitoBeanOverrideHandler
extends BeanOverrideHandler {
    private final MockReset reset;

    protected AbstractMockitoBeanOverrideHandler(@Nullable Field field, ResolvableType beanType, @Nullable String beanName, BeanOverrideStrategy strategy, MockReset reset) {
        super(field, beanType, beanName, strategy);
        this.reset = reset != null ? reset : MockReset.AFTER;
    }

    MockReset getReset() {
        return this.reset;
    }

    @Override
    protected void trackOverrideInstance(Object mock, SingletonBeanRegistry trackingBeanRegistry) {
        AbstractMockitoBeanOverrideHandler.getMockBeans(trackingBeanRegistry).add(mock);
    }

    private static MockBeans getMockBeans(SingletonBeanRegistry trackingBeanRegistry) {
        String beanName = MockBeans.class.getName();
        MockBeans mockBeans = null;
        if (trackingBeanRegistry.containsSingleton(beanName)) {
            mockBeans = (MockBeans)trackingBeanRegistry.getSingleton(beanName);
        }
        if (mockBeans == null) {
            mockBeans = new MockBeans();
            trackingBeanRegistry.registerSingleton(beanName, (Object)mockBeans);
        }
        return mockBeans;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        AbstractMockitoBeanOverrideHandler that;
        if (other == this) {
            return true;
        }
        return other instanceof AbstractMockitoBeanOverrideHandler && super.equals(that = (AbstractMockitoBeanOverrideHandler)other) && this.reset == that.reset;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.reset.hashCode();
    }

    @Override
    public String toString() {
        return new ToStringCreator((Object)this).append("field", (Object)this.getField()).append("beanType", (Object)this.getBeanType()).append("beanName", (Object)this.getBeanName()).append("strategy", (Object)this.getStrategy()).append("reset", (Object)this.getReset()).toString();
    }
}

