/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.bean.override.mockito;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashSet;
import java.util.function.Predicate;
import org.mockito.Mockito;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.lang.Nullable;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.TestContextAnnotationUtils;
import org.springframework.test.context.bean.override.mockito.MockReset;
import org.springframework.test.context.bean.override.mockito.MockitoBeans;
import org.springframework.test.context.support.AbstractTestExecutionListener;
import org.springframework.util.ClassUtils;

public class MockitoResetTestExecutionListener
extends AbstractTestExecutionListener {
    static final boolean mockitoPresent = ClassUtils.isPresent((String)"org.mockito.Mockito", (ClassLoader)MockitoResetTestExecutionListener.class.getClassLoader());
    private static final String SPRING_MOCKITO_PACKAGE = "org.springframework.test.context.bean.override.mockito";
    private static final Predicate<MergedAnnotation<?>> isSpringMockitoAnnotation = mergedAnnotation -> mergedAnnotation.getType().getPackageName().equals(SPRING_MOCKITO_PACKAGE);

    @Override
    public int getOrder() {
        return 2147483547;
    }

    @Override
    public void beforeTestMethod(TestContext testContext) {
        if (mockitoPresent && MockitoResetTestExecutionListener.hasMockitoAnnotations(testContext)) {
            this.resetMocks(testContext.getApplicationContext(), MockReset.BEFORE);
        }
    }

    @Override
    public void afterTestMethod(TestContext testContext) {
        if (mockitoPresent && MockitoResetTestExecutionListener.hasMockitoAnnotations(testContext)) {
            this.resetMocks(testContext.getApplicationContext(), MockReset.AFTER);
        }
    }

    private void resetMocks(ApplicationContext applicationContext, MockReset reset) {
        if (applicationContext instanceof ConfigurableApplicationContext) {
            ConfigurableApplicationContext configurableContext = (ConfigurableApplicationContext)applicationContext;
            this.resetMocks(configurableContext, reset);
        }
    }

    private void resetMocks(ConfigurableApplicationContext applicationContext, MockReset reset) {
        ConfigurableListableBeanFactory beanFactory = applicationContext.getBeanFactory();
        String[] beanNames = beanFactory.getBeanDefinitionNames();
        HashSet<String> instantiatedSingletons = new HashSet<String>(Arrays.asList(beanFactory.getSingletonNames()));
        for (String beanName : beanNames) {
            Object bean;
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition(beanName);
            if (!beanDefinition.isSingleton() || !instantiatedSingletons.contains(beanName) || (bean = MockitoResetTestExecutionListener.getBean(beanFactory, beanName)) == null || reset != MockReset.get(bean)) continue;
            Mockito.reset((Object[])new Object[]{bean});
        }
        try {
            ((MockitoBeans)beanFactory.getBean(MockitoBeans.class)).resetAll();
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
        if (applicationContext.getParent() != null) {
            this.resetMocks(applicationContext.getParent(), reset);
        }
    }

    @Nullable
    private static Object getBean(ConfigurableListableBeanFactory beanFactory, String beanName) {
        try {
            if (MockitoResetTestExecutionListener.isStandardBeanOrSingletonFactoryBean((BeanFactory)beanFactory, beanName)) {
                return beanFactory.getBean(beanName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return beanFactory.getSingleton(beanName);
    }

    private static boolean isStandardBeanOrSingletonFactoryBean(BeanFactory beanFactory, String beanName) {
        String factoryBeanName = "&" + beanName;
        if (beanFactory.containsBean(factoryBeanName)) {
            FactoryBean factoryBean = (FactoryBean)beanFactory.getBean(factoryBeanName);
            return factoryBean.isSingleton();
        }
        return true;
    }

    static boolean hasMockitoAnnotations(TestContext testContext) {
        return MockitoResetTestExecutionListener.hasMockitoAnnotations(testContext.getTestClass());
    }

    private static boolean hasMockitoAnnotations(Class<?> clazz) {
        if (MockitoResetTestExecutionListener.isAnnotated(clazz)) {
            return true;
        }
        for (Field field : clazz.getDeclaredFields()) {
            if (!MockitoResetTestExecutionListener.isAnnotated(field)) continue;
            return true;
        }
        for (AnnotatedElement annotatedElement : clazz.getInterfaces()) {
            if (!MockitoResetTestExecutionListener.hasMockitoAnnotations(annotatedElement)) continue;
            return true;
        }
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null & superclass != Object.class && MockitoResetTestExecutionListener.hasMockitoAnnotations(superclass)) {
            return true;
        }
        return TestContextAnnotationUtils.searchEnclosingClass(clazz) && MockitoResetTestExecutionListener.hasMockitoAnnotations(clazz.getEnclosingClass());
    }

    private static boolean isAnnotated(AnnotatedElement element) {
        return MergedAnnotations.from((AnnotatedElement)element, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.DIRECT).stream().anyMatch(isSpringMockitoAnnotation);
    }
}

