/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.bean.override;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.aop.scope.ScopedProxyUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.config.SingletonBeanRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.beans.factory.support.DefaultBeanNameGenerator;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.Ordered;
import org.springframework.core.ResolvableType;
import org.springframework.lang.Nullable;
import org.springframework.test.context.bean.override.BeanOverrideHandler;
import org.springframework.test.context.bean.override.BeanOverrideRegistry;
import org.springframework.util.Assert;

class BeanOverrideBeanFactoryPostProcessor
implements BeanFactoryPostProcessor,
Ordered {
    private static final String PSEUDO_BEAN_NAME_PLACEHOLDER = "<<< PSEUDO BEAN NAME PLACEHOLDER >>>";
    private static final BeanNameGenerator beanNameGenerator = DefaultBeanNameGenerator.INSTANCE;
    private final Set<BeanOverrideHandler> beanOverrideHandlers;
    private final BeanOverrideRegistry beanOverrideRegistry;

    BeanOverrideBeanFactoryPostProcessor(Set<BeanOverrideHandler> beanOverrideHandlers, BeanOverrideRegistry beanOverrideRegistry) {
        this.beanOverrideHandlers = beanOverrideHandlers;
        this.beanOverrideRegistry = beanOverrideRegistry;
    }

    public int getOrder() {
        return 0x7FFFFFF5;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        for (BeanOverrideHandler handler : this.beanOverrideHandlers) {
            this.registerBeanOverride(beanFactory, handler);
        }
    }

    private void registerBeanOverride(ConfigurableListableBeanFactory beanFactory, BeanOverrideHandler handler) {
        String beanName = handler.getBeanName();
        Field field = handler.getField();
        Assert.state((!BeanFactoryUtils.isFactoryDereference((String)beanName) ? 1 : 0) != 0, () -> "Unable to override bean '%s' for field '%s.%s': a FactoryBean cannot be overridden. To override the bean created by the FactoryBean, remove the '&' prefix.".formatted(beanName, field.getDeclaringClass().getSimpleName(), field.getName()));
        switch (handler.getStrategy()) {
            case REPLACE: {
                this.replaceOrCreateBean(beanFactory, handler, true);
                break;
            }
            case REPLACE_OR_CREATE: {
                this.replaceOrCreateBean(beanFactory, handler, false);
                break;
            }
            case WRAP: {
                this.wrapBean(beanFactory, handler);
            }
        }
    }

    private void replaceOrCreateBean(ConfigurableListableBeanFactory beanFactory, BeanOverrideHandler handler, boolean requireExistingBean) {
        String beanName = handler.getBeanName();
        BeanDefinition existingBeanDefinition = null;
        if (beanName == null) {
            beanName = this.getBeanNameForType(beanFactory, handler, requireExistingBean);
            if (beanName != null) {
                if (beanFactory.containsBeanDefinition(beanName = BeanFactoryUtils.transformedBeanName((String)beanName))) {
                    existingBeanDefinition = beanFactory.getBeanDefinition(beanName);
                }
            } else {
                beanName = PSEUDO_BEAN_NAME_PLACEHOLDER;
            }
        } else {
            Set<String> candidates = this.getExistingBeanNamesByType(beanFactory, handler, false);
            if (candidates.contains(beanName)) {
                existingBeanDefinition = beanFactory.getBeanDefinition(beanName);
            } else if (requireExistingBean) {
                throw new IllegalStateException("Unable to override bean: there is no bean to replace with name [%s] and type [%s].".formatted(beanName, handler.getBeanType()));
            }
        }
        if (existingBeanDefinition != null) {
            BeanOverrideBeanFactoryPostProcessor.validateBeanDefinition(beanFactory, beanName);
        } else if (!Boolean.getBoolean("spring.aot.processing")) {
            if (!(beanFactory instanceof BeanDefinitionRegistry)) {
                throw new IllegalStateException("Cannot process bean override with a BeanFactory that doesn't implement BeanDefinitionRegistry: " + beanFactory.getClass().getName());
            }
            BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
            RootBeanDefinition pseudoBeanDefinition = BeanOverrideBeanFactoryPostProcessor.createPseudoBeanDefinition(handler);
            if (PSEUDO_BEAN_NAME_PLACEHOLDER.equals(beanName)) {
                beanName = beanNameGenerator.generateBeanName((BeanDefinition)pseudoBeanDefinition, registry);
            }
            registry.registerBeanDefinition(beanName, (BeanDefinition)pseudoBeanDefinition);
        }
        Object override = handler.createOverrideInstance(beanName, existingBeanDefinition, null, (SingletonBeanRegistry)beanFactory);
        this.beanOverrideRegistry.registerBeanOverrideHandler(handler, beanName);
        if (beanFactory.containsSingleton(beanName)) {
            BeanOverrideBeanFactoryPostProcessor.destroySingleton(beanFactory, beanName);
        }
        beanFactory.registerSingleton(beanName, override);
    }

    private void wrapBean(ConfigurableListableBeanFactory beanFactory, BeanOverrideHandler handler) {
        String beanName = handler.getBeanName();
        if (beanName == null) {
            Set<String> candidateNames = this.getExistingBeanNamesByType(beanFactory, handler, true);
            int candidateCount = candidateNames.size();
            if (candidateCount != 1) {
                Field field = handler.getField();
                throw new IllegalStateException("Unable to select a bean to override by wrapping: found %d bean instances of type %s (as required by annotated field '%s.%s')%s".formatted(candidateCount, handler.getBeanType(), field.getDeclaringClass().getSimpleName(), field.getName(), candidateCount > 0 ? ": " + candidateNames : ""));
            }
            beanName = BeanFactoryUtils.transformedBeanName((String)candidateNames.iterator().next());
        } else {
            Set<String> candidates = this.getExistingBeanNamesByType(beanFactory, handler, false);
            if (!candidates.contains(beanName)) {
                throw new IllegalStateException("Unable to override bean by wrapping: there is no existing bean with name [%s] and type [%s].".formatted(beanName, handler.getBeanType()));
            }
        }
        BeanOverrideBeanFactoryPostProcessor.validateBeanDefinition(beanFactory, beanName);
        this.beanOverrideRegistry.registerBeanOverrideHandler(handler, beanName);
    }

    @Nullable
    private String getBeanNameForType(ConfigurableListableBeanFactory beanFactory, BeanOverrideHandler handler, boolean requireExistingBean) {
        Set<String> candidateNames = this.getExistingBeanNamesByType(beanFactory, handler, true);
        int candidateCount = candidateNames.size();
        if (candidateCount == 1) {
            return candidateNames.iterator().next();
        }
        if (candidateCount == 0) {
            if (requireExistingBean) {
                Field field = handler.getField();
                throw new IllegalStateException("Unable to override bean: no beans of type %s (as required by annotated field '%s.%s')".formatted(handler.getBeanType(), field.getDeclaringClass().getSimpleName(), field.getName()));
            }
            return null;
        }
        Field field = handler.getField();
        throw new IllegalStateException("Unable to select a bean to override: found %s beans of type %s (as required by annotated field '%s.%s'): %s".formatted(candidateCount, handler.getBeanType(), field.getDeclaringClass().getSimpleName(), field.getName(), candidateNames));
    }

    private Set<String> getExistingBeanNamesByType(ConfigurableListableBeanFactory beanFactory, BeanOverrideHandler handler, boolean checkAutowiredCandidate) {
        String fieldName;
        ResolvableType resolvableType = handler.getBeanType();
        Class type = resolvableType.toClass();
        LinkedHashSet<String> beanNames = new LinkedHashSet<String>(Arrays.asList(beanFactory.getBeanNamesForType(resolvableType, true, false)));
        for (String beanName2 : beanFactory.getBeanNamesForType(FactoryBean.class, true, false)) {
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition(beanName2 = BeanFactoryUtils.transformedBeanName((String)beanName2));
            Object attribute = beanDefinition.getAttribute("factoryBeanObjectType");
            if (!resolvableType.equals(attribute) && !type.equals(attribute)) continue;
            beanNames.add(beanName2);
        }
        if (checkAutowiredCandidate) {
            DependencyDescriptor descriptor = new DependencyDescriptor(handler.getField(), true);
            beanNames.removeIf(beanName -> !beanFactory.isAutowireCandidate(beanName, descriptor));
        }
        beanNames.removeIf(ScopedProxyUtils::isScopedTarget);
        if (beanNames.size() > 1 && beanNames.contains(fieldName = handler.getField().getName())) {
            return Set.of(fieldName);
        }
        return beanNames;
    }

    private static RootBeanDefinition createPseudoBeanDefinition(BeanOverrideHandler handler) {
        RootBeanDefinition definition = new RootBeanDefinition(handler.getBeanType().resolve());
        definition.setTargetType(handler.getBeanType());
        definition.setQualifiedElement((AnnotatedElement)handler.getField());
        return definition;
    }

    private static void validateBeanDefinition(ConfigurableListableBeanFactory beanFactory, String beanName) {
        Assert.state((boolean)beanFactory.isSingleton(beanName), () -> "Unable to override bean '" + beanName + "': only singleton beans can be overridden.");
    }

    private static void destroySingleton(ConfigurableListableBeanFactory beanFactory, String beanName) {
        if (!(beanFactory instanceof DefaultListableBeanFactory)) {
            throw new IllegalStateException("Cannot process bean override with a BeanFactory that doesn't implement DefaultListableBeanFactory: " + beanFactory.getClass().getName());
        }
        DefaultListableBeanFactory dlbf = (DefaultListableBeanFactory)beanFactory;
        dlbf.destroySingleton(beanName);
    }
}

