/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.bean.override.mockito;

import java.lang.reflect.Field;
import java.util.Objects;
import org.springframework.beans.factory.config.SingletonBeanRegistry;
import org.springframework.core.ResolvableType;
import org.springframework.core.style.ToStringCreator;
import org.springframework.lang.Nullable;
import org.springframework.test.context.bean.override.BeanOverrideHandler;
import org.springframework.test.context.bean.override.BeanOverrideStrategy;
import org.springframework.test.context.bean.override.mockito.MockReset;
import org.springframework.test.context.bean.override.mockito.MockitoBeans;

abstract class AbstractMockitoBeanOverrideHandler
extends BeanOverrideHandler {
    private final MockReset reset;
    private final boolean proxyTargetAware;

    protected AbstractMockitoBeanOverrideHandler(Field field, ResolvableType beanType, @Nullable String beanName, BeanOverrideStrategy strategy, @Nullable MockReset reset, boolean proxyTargetAware) {
        super(field, beanType, beanName, strategy);
        this.reset = reset != null ? reset : MockReset.AFTER;
        this.proxyTargetAware = proxyTargetAware;
    }

    MockReset getReset() {
        return this.reset;
    }

    boolean isProxyTargetAware() {
        return this.proxyTargetAware;
    }

    @Override
    protected void trackOverrideInstance(Object mock, SingletonBeanRegistry trackingBeanRegistry) {
        AbstractMockitoBeanOverrideHandler.getMockitoBeans(trackingBeanRegistry).add(mock);
    }

    private static MockitoBeans getMockitoBeans(SingletonBeanRegistry trackingBeanRegistry) {
        String beanName = MockitoBeans.class.getName();
        MockitoBeans mockitoBeans = null;
        if (trackingBeanRegistry.containsSingleton(beanName)) {
            mockitoBeans = (MockitoBeans)trackingBeanRegistry.getSingleton(beanName);
        }
        if (mockitoBeans == null) {
            mockitoBeans = new MockitoBeans();
            trackingBeanRegistry.registerSingleton(beanName, (Object)mockitoBeans);
        }
        return mockitoBeans;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        AbstractMockitoBeanOverrideHandler that;
        if (other == this) {
            return true;
        }
        return other instanceof AbstractMockitoBeanOverrideHandler && super.equals(that = (AbstractMockitoBeanOverrideHandler)other) && this.reset == that.reset && this.proxyTargetAware == that.proxyTargetAware;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Objects.hash(new Object[]{this.reset, this.proxyTargetAware});
    }

    @Override
    public String toString() {
        return new ToStringCreator((Object)this).append("field", (Object)this.getField()).append("beanType", (Object)this.getBeanType()).append("beanName", (Object)this.getBeanName()).append("strategy", (Object)this.getStrategy()).append("reset", (Object)this.getReset()).append("proxyTargetAware", this.isProxyTargetAware()).toString();
    }
}

