/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Set;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.lang.Nullable;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.DynamicPropertyRegistry;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.support.DynamicPropertyRegistrarBeanInitializer;
import org.springframework.test.context.support.DynamicValuesPropertySource;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

class DynamicPropertiesContextCustomizer
implements ContextCustomizer {
    private static final String DYNAMIC_PROPERTY_REGISTRAR_BEAN_INITIALIZER_BEAN_NAME = DynamicPropertiesContextCustomizer.class.getName() + ".dynamicPropertyRegistrarBeanInitializer";
    private final Set<Method> methods;

    DynamicPropertiesContextCustomizer(Set<Method> methods) {
        methods.forEach(DynamicPropertiesContextCustomizer::assertValid);
        this.methods = methods;
    }

    @Override
    public void customizeContext(ConfigurableApplicationContext context, MergedContextConfiguration mergedConfig) {
        ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
        if (!(beanFactory instanceof BeanDefinitionRegistry)) {
            throw new IllegalStateException("BeanFactory must be a BeanDefinitionRegistry");
        }
        BeanDefinitionRegistry beanDefinitionRegistry = (BeanDefinitionRegistry)beanFactory;
        if (!beanDefinitionRegistry.containsBeanDefinition(DYNAMIC_PROPERTY_REGISTRAR_BEAN_INITIALIZER_BEAN_NAME)) {
            RootBeanDefinition beanDefinition = new RootBeanDefinition(DynamicPropertyRegistrarBeanInitializer.class);
            beanDefinition.setRole(2);
            beanDefinitionRegistry.registerBeanDefinition(DYNAMIC_PROPERTY_REGISTRAR_BEAN_INITIALIZER_BEAN_NAME, (BeanDefinition)beanDefinition);
        }
        if (!this.methods.isEmpty()) {
            ConfigurableEnvironment environment = context.getEnvironment();
            DynamicValuesPropertySource propertySource = DynamicValuesPropertySource.getOrCreate(environment);
            DynamicPropertyRegistry registry = propertySource.dynamicPropertyRegistry;
            this.methods.forEach(method -> {
                ReflectionUtils.makeAccessible((Method)method);
                ReflectionUtils.invokeMethod((Method)method, null, (Object[])new Object[]{registry});
            });
        }
    }

    Set<Method> getMethods() {
        return this.methods;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!(other instanceof DynamicPropertiesContextCustomizer)) return false;
        DynamicPropertiesContextCustomizer that = (DynamicPropertiesContextCustomizer)other;
        if (!this.methods.equals(that.methods)) return false;
        return true;
    }

    public int hashCode() {
        return this.methods.hashCode();
    }

    private static void assertValid(Method method) {
        Assert.state((boolean)Modifier.isStatic(method.getModifiers()), () -> "@DynamicPropertySource method '" + method.getName() + "' must be static");
        Class<?>[] types = method.getParameterTypes();
        Assert.state((types.length == 1 && types[0] == DynamicPropertyRegistry.class ? 1 : 0) != 0, () -> "@DynamicPropertySource method '" + method.getName() + "' must accept a single DynamicPropertyRegistry argument");
    }
}

