/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.bean.override.mockito;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.LinkedHashSet;
import java.util.Set;
import org.mockito.Mockito;
import org.mockito.MockitoSession;
import org.mockito.quality.Strictness;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.bean.override.mockito.MockitoBean;
import org.springframework.test.context.bean.override.mockito.MockitoBeanSettings;
import org.springframework.test.context.support.AbstractTestExecutionListener;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class MockitoTestExecutionListener
extends AbstractTestExecutionListener {
    private static final String MOCKS_ATTRIBUTE_NAME = MockitoTestExecutionListener.class.getName() + ".mocks";
    static final boolean mockitoPresent = ClassUtils.isPresent((String)"org.mockito.MockSettings", (ClassLoader)MockitoTestExecutionListener.class.getClassLoader());

    @Override
    public final int getOrder() {
        return 1950;
    }

    @Override
    public void prepareTestInstance(TestContext testContext) throws Exception {
        if (mockitoPresent) {
            this.closeMocks(testContext);
            this.initMocks(testContext);
        }
    }

    @Override
    public void beforeTestMethod(TestContext testContext) throws Exception {
        if (mockitoPresent && Boolean.TRUE.equals(testContext.getAttribute(DependencyInjectionTestExecutionListener.REINJECT_DEPENDENCIES_ATTRIBUTE))) {
            this.closeMocks(testContext);
            this.initMocks(testContext);
        }
    }

    @Override
    public void afterTestMethod(TestContext testContext) throws Exception {
        if (mockitoPresent) {
            this.closeMocks(testContext);
        }
    }

    @Override
    public void afterTestClass(TestContext testContext) throws Exception {
        if (mockitoPresent) {
            this.closeMocks(testContext);
        }
    }

    private void initMocks(TestContext testContext) {
        if (this.hasMockitoAnnotations(testContext)) {
            Object testInstance;
            MockitoBeanSettings annotation = (MockitoBeanSettings)AnnotationUtils.findAnnotation((testInstance = testContext.getTestInstance()).getClass(), MockitoBeanSettings.class);
            testContext.setAttribute(MOCKS_ATTRIBUTE_NAME, this.initMockitoSession(testInstance, annotation != null ? annotation.value() : Strictness.STRICT_STUBS));
        }
    }

    private MockitoSession initMockitoSession(Object testInstance, Strictness strictness) {
        return Mockito.mockitoSession().initMocks(testInstance).strictness(strictness).startMocking();
    }

    private void closeMocks(TestContext testContext) throws Exception {
        Object mocks = testContext.getAttribute(MOCKS_ATTRIBUTE_NAME);
        if (mocks instanceof MockitoSession) {
            MockitoSession session = (MockitoSession)mocks;
            session.finishMocking();
        }
    }

    private boolean hasMockitoAnnotations(TestContext testContext) {
        MockitoAnnotationCollector collector = new MockitoAnnotationCollector();
        collector.collect(testContext.getTestClass());
        return collector.hasAnnotations();
    }

    private static final class MockitoAnnotationCollector
    implements ReflectionUtils.FieldCallback {
        private static final String MOCKITO_BEAN_PACKAGE = MockitoBean.class.getPackageName();
        private static final String ORG_MOCKITO_PACKAGE = "org.mockito";
        private final Set<Annotation> annotations = new LinkedHashSet<Annotation>();

        private MockitoAnnotationCollector() {
        }

        public void collect(Class<?> clazz) {
            ReflectionUtils.doWithFields(clazz, (ReflectionUtils.FieldCallback)this);
            for (Annotation annotation : clazz.getAnnotations()) {
                this.collect(annotation);
            }
        }

        public void doWith(Field field) throws IllegalArgumentException {
            for (Annotation annotation : field.getAnnotations()) {
                this.collect(annotation);
            }
        }

        private void collect(Annotation annotation) {
            String packageName = annotation.annotationType().getPackageName();
            if (packageName.startsWith(MOCKITO_BEAN_PACKAGE) || packageName.startsWith(ORG_MOCKITO_PACKAGE)) {
                this.annotations.add(annotation);
            }
        }

        boolean hasAnnotations() {
            return !this.annotations.isEmpty();
        }
    }
}

