/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.bean.override;

import java.lang.reflect.Field;
import java.util.List;
import java.util.function.BiConsumer;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.bean.override.BeanOverrideRegistrar;
import org.springframework.test.context.bean.override.OverrideMetadata;
import org.springframework.test.context.support.AbstractTestExecutionListener;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.util.ReflectionUtils;

public class BeanOverrideTestExecutionListener
extends AbstractTestExecutionListener {
    @Override
    public int getOrder() {
        return 2147483597;
    }

    @Override
    public void prepareTestInstance(TestContext testContext) throws Exception {
        this.injectFields(testContext);
    }

    @Override
    public void beforeTestMethod(TestContext testContext) throws Exception {
        this.reinjectFieldsIfConfigured(testContext);
    }

    protected void injectFields(TestContext testContext) {
        this.postProcessFields(testContext, (testMetadata, overrideRegistrar) -> overrideRegistrar.inject(testMetadata.testInstance, testMetadata.overrideMetadata));
    }

    protected void reinjectFieldsIfConfigured(TestContext testContext) throws Exception {
        if (Boolean.TRUE.equals(testContext.getAttribute(DependencyInjectionTestExecutionListener.REINJECT_DEPENDENCIES_ATTRIBUTE))) {
            this.postProcessFields(testContext, (testMetadata, registrar) -> {
                Object testInstance = testMetadata.testInstance;
                Field field = testMetadata.overrideMetadata.getField();
                ReflectionUtils.makeAccessible((Field)field);
                ReflectionUtils.setField((Field)field, (Object)testInstance, null);
                registrar.inject(testInstance, testMetadata.overrideMetadata);
            });
        }
    }

    private void postProcessFields(TestContext testContext, BiConsumer<TestContextOverrideMetadata, BeanOverrideRegistrar> consumer) {
        Class<?> testClass = testContext.getTestClass();
        Object testInstance = testContext.getTestInstance();
        List<OverrideMetadata> metadataForFields = OverrideMetadata.forTestClass(testClass);
        if (!metadataForFields.isEmpty()) {
            BeanOverrideRegistrar registrar = (BeanOverrideRegistrar)testContext.getApplicationContext().getBean(BeanOverrideRegistrar.class);
            for (OverrideMetadata metadata : metadataForFields) {
                consumer.accept(new TestContextOverrideMetadata(testInstance, metadata), registrar);
            }
        }
    }

    private record TestContextOverrideMetadata(Object testInstance, OverrideMetadata overrideMetadata) {
    }
}

