/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.bean.override;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.lang.Nullable;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.ContextCustomizerFactory;
import org.springframework.test.context.TestContextAnnotationUtils;
import org.springframework.test.context.bean.override.BeanOverrideContextCustomizer;
import org.springframework.test.context.bean.override.OverrideMetadata;

class BeanOverrideContextCustomizerFactory
implements ContextCustomizerFactory {
    BeanOverrideContextCustomizerFactory() {
    }

    @Override
    @Nullable
    public BeanOverrideContextCustomizer createContextCustomizer(Class<?> testClass, List<ContextConfigurationAttributes> configAttributes) {
        HashSet<OverrideMetadata> metadata = new HashSet<OverrideMetadata>();
        this.findOverrideMetadata(testClass, metadata);
        if (metadata.isEmpty()) {
            return null;
        }
        return new BeanOverrideContextCustomizer(metadata);
    }

    private void findOverrideMetadata(Class<?> testClass, Set<OverrideMetadata> metadata) {
        List<OverrideMetadata> overrideMetadata = OverrideMetadata.forTestClass(testClass);
        metadata.addAll(overrideMetadata);
        if (TestContextAnnotationUtils.searchEnclosingClass(testClass)) {
            this.findOverrideMetadata(testClass.getEnclosingClass(), metadata);
        }
    }
}

