/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.bean.override;

import java.util.Set;
import java.util.function.Consumer;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.bean.override.BeanOverrideBeanFactoryPostProcessor;
import org.springframework.test.context.bean.override.BeanOverrideRegistrar;
import org.springframework.test.context.bean.override.OverrideMetadata;

class BeanOverrideContextCustomizer
implements ContextCustomizer {
    private static final String REGISTRAR_BEAN_NAME = "org.springframework.test.context.bean.override.internalBeanOverrideRegistrar";
    private static final String INFRASTRUCTURE_BEAN_NAME = "org.springframework.test.context.bean.override.internalBeanOverridePostProcessor";
    private static final String EARLY_INFRASTRUCTURE_BEAN_NAME = "org.springframework.test.context.bean.override.internalWrapEarlyBeanPostProcessor";
    private final Set<OverrideMetadata> metadata;

    BeanOverrideContextCustomizer(Set<OverrideMetadata> metadata) {
        this.metadata = metadata;
    }

    @Override
    public void customizeContext(ConfigurableApplicationContext context, MergedContextConfiguration mergedConfig) {
        if (!(context instanceof BeanDefinitionRegistry)) {
            throw new IllegalStateException("Cannot process bean overrides with an ApplicationContext that doesn't implement BeanDefinitionRegistry: " + context.getClass());
        }
        BeanDefinitionRegistry registry = (BeanDefinitionRegistry)context;
        this.registerInfrastructure(registry);
    }

    Set<OverrideMetadata> getMetadata() {
        return this.metadata;
    }

    private void registerInfrastructure(BeanDefinitionRegistry registry) {
        this.addInfrastructureBeanDefinition(registry, BeanOverrideRegistrar.class, REGISTRAR_BEAN_NAME, constructorArgs -> {});
        RuntimeBeanReference registrarReference = new RuntimeBeanReference(REGISTRAR_BEAN_NAME);
        this.addInfrastructureBeanDefinition(registry, BeanOverrideBeanFactoryPostProcessor.WrapEarlyBeanPostProcessor.class, EARLY_INFRASTRUCTURE_BEAN_NAME, constructorArgs -> constructorArgs.addIndexedArgumentValue(0, (Object)registrarReference));
        this.addInfrastructureBeanDefinition(registry, BeanOverrideBeanFactoryPostProcessor.class, INFRASTRUCTURE_BEAN_NAME, constructorArgs -> {
            constructorArgs.addIndexedArgumentValue(0, this.metadata);
            constructorArgs.addIndexedArgumentValue(1, (Object)registrarReference);
        });
    }

    private void addInfrastructureBeanDefinition(BeanDefinitionRegistry registry, Class<?> clazz, String beanName, Consumer<ConstructorArgumentValues> constructorArgumentsConsumer) {
        if (!registry.containsBeanDefinition(beanName)) {
            RootBeanDefinition definition = new RootBeanDefinition(clazz);
            definition.setRole(2);
            ConstructorArgumentValues constructorArguments = definition.getConstructorArgumentValues();
            constructorArgumentsConsumer.accept(constructorArguments);
            registry.registerBeanDefinition(beanName, (BeanDefinition)definition);
        }
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        BeanOverrideContextCustomizer that = (BeanOverrideContextCustomizer)other;
        return this.metadata.equals(that.metadata);
    }

    public int hashCode() {
        return this.metadata.hashCode();
    }
}

