/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.request;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.springframework.beans.Mergeable;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.lang.Nullable;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockHttpSession;
import org.springframework.test.web.servlet.request.ConfigurableSmartRequestBuilder;
import org.springframework.test.web.servlet.request.RequestPostProcessor;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.servlet.FlashMap;
import org.springframework.web.servlet.FlashMapManager;
import org.springframework.web.servlet.support.SessionFlashMapManager;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriUtils;
import org.springframework.web.util.UrlPathHelper;

public abstract class AbstractMockHttpServletRequestBuilder<B extends AbstractMockHttpServletRequestBuilder<B>>
implements ConfigurableSmartRequestBuilder<B>,
Mergeable {
    private final HttpMethod method;
    @Nullable
    private URI uri;
    private String contextPath = "";
    private String servletPath = "";
    @Nullable
    private String pathInfo = "";
    @Nullable
    private Boolean secure;
    @Nullable
    private Principal principal;
    @Nullable
    private MockHttpSession session;
    @Nullable
    private String remoteAddress;
    @Nullable
    private String characterEncoding;
    @Nullable
    private byte[] content;
    @Nullable
    private String contentType;
    private final MultiValueMap<String, Object> headers = new LinkedMultiValueMap();
    private final MultiValueMap<String, String> parameters = new LinkedMultiValueMap();
    private final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap();
    private final MultiValueMap<String, String> formFields = new LinkedMultiValueMap();
    private final List<Cookie> cookies = new ArrayList<Cookie>();
    private final List<Locale> locales = new ArrayList<Locale>();
    private final Map<String, Object> requestAttributes = new LinkedHashMap<String, Object>();
    private final Map<String, Object> sessionAttributes = new LinkedHashMap<String, Object>();
    private final Map<String, Object> flashAttributes = new LinkedHashMap<String, Object>();
    private final List<RequestPostProcessor> postProcessors = new ArrayList<RequestPostProcessor>();

    protected AbstractMockHttpServletRequestBuilder(HttpMethod httpMethod) {
        Assert.notNull((Object)httpMethod, (String)"'httpMethod' is required");
        this.method = httpMethod;
    }

    protected B self() {
        return (B)this;
    }

    public B uri(URI uri) {
        this.uri = uri;
        return this.self();
    }

    public B uri(String uriTemplate, Object ... uriVariables) {
        return this.uri(AbstractMockHttpServletRequestBuilder.initUri(uriTemplate, uriVariables));
    }

    private static URI initUri(String uri, Object[] vars) {
        Assert.notNull((Object)uri, (String)"'uri' must not be null");
        Assert.isTrue((uri.isEmpty() || uri.startsWith("/") || uri.startsWith("http://") || uri.startsWith("https://") ? 1 : 0) != 0, () -> "'uri' should start with a path or be a complete HTTP URI: " + uri);
        String uriString = uri.isEmpty() ? "/" : uri;
        return UriComponentsBuilder.fromUriString((String)uriString).buildAndExpand(vars).encode().toUri();
    }

    public B contextPath(String contextPath) {
        if (StringUtils.hasText((String)contextPath)) {
            Assert.isTrue((boolean)contextPath.startsWith("/"), (String)"Context path must start with a '/'");
            Assert.isTrue((!contextPath.endsWith("/") ? 1 : 0) != 0, (String)"Context path must not end with a '/'");
        }
        this.contextPath = contextPath;
        return this.self();
    }

    public B servletPath(String servletPath) {
        if (StringUtils.hasText((String)servletPath)) {
            Assert.isTrue((boolean)servletPath.startsWith("/"), (String)"Servlet path must start with a '/'");
            Assert.isTrue((!servletPath.endsWith("/") ? 1 : 0) != 0, (String)"Servlet path must not end with a '/'");
        }
        this.servletPath = servletPath;
        return this.self();
    }

    public B pathInfo(@Nullable String pathInfo) {
        if (StringUtils.hasText((String)pathInfo)) {
            Assert.isTrue((boolean)pathInfo.startsWith("/"), (String)"Path info must start with a '/'");
        }
        this.pathInfo = pathInfo;
        return this.self();
    }

    public B secure(boolean secure) {
        this.secure = secure;
        return this.self();
    }

    public B characterEncoding(Charset encoding) {
        return this.characterEncoding(encoding.name());
    }

    public B characterEncoding(String encoding) {
        this.characterEncoding = encoding;
        return this.self();
    }

    public B content(byte[] content) {
        this.content = content;
        return this.self();
    }

    public B content(String content) {
        this.content = content.getBytes(StandardCharsets.UTF_8);
        return this.self();
    }

    public B contentType(MediaType contentType) {
        Assert.notNull((Object)contentType, (String)"'contentType' must not be null");
        this.contentType = contentType.toString();
        return this.self();
    }

    public B contentType(String contentType) {
        Assert.notNull((Object)contentType, (String)"'contentType' must not be null");
        this.contentType = contentType;
        return this.self();
    }

    public B accept(MediaType ... mediaTypes) {
        Assert.notEmpty((Object[])mediaTypes, (String)"'mediaTypes' must not be empty");
        this.headers.set((Object)"Accept", (Object)MediaType.toString(Arrays.asList(mediaTypes)));
        return this.self();
    }

    public B accept(String ... mediaTypes) {
        Assert.notEmpty((Object[])mediaTypes, (String)"'mediaTypes' must not be empty");
        this.headers.set((Object)"Accept", (Object)String.join((CharSequence)", ", mediaTypes));
        return this.self();
    }

    public B header(String name, Object ... values) {
        AbstractMockHttpServletRequestBuilder.addToMultiValueMap(this.headers, name, values);
        return this.self();
    }

    public B headers(HttpHeaders httpHeaders) {
        httpHeaders.forEach((arg_0, arg_1) -> this.headers.addAll(arg_0, arg_1));
        return this.self();
    }

    public B param(String name, String ... values) {
        AbstractMockHttpServletRequestBuilder.addToMultiValueMap(this.parameters, name, values);
        return this.self();
    }

    public B params(MultiValueMap<String, String> params) {
        params.forEach((name, values) -> {
            for (String value : values) {
                this.parameters.add(name, (Object)value);
            }
        });
        return this.self();
    }

    public B queryParam(String name, String ... values) {
        this.param(name, values);
        this.queryParams.addAll((Object)name, Arrays.asList(values));
        return this.self();
    }

    public B queryParams(MultiValueMap<String, String> params) {
        this.params(params);
        this.queryParams.addAll(params);
        return this.self();
    }

    public B formField(String name, String ... values) {
        this.param(name, values);
        this.formFields.addAll((Object)name, Arrays.asList(values));
        return this.self();
    }

    public B formFields(MultiValueMap<String, String> formFields) {
        this.params(formFields);
        this.formFields.addAll(formFields);
        return this.self();
    }

    public B cookie(Cookie ... cookies) {
        Assert.notEmpty((Object[])cookies, (String)"'cookies' must not be empty");
        this.cookies.addAll(Arrays.asList(cookies));
        return this.self();
    }

    public B locale(Locale ... locales) {
        Assert.notEmpty((Object[])locales, (String)"'locales' must not be empty");
        this.locales.addAll(Arrays.asList(locales));
        return this.self();
    }

    public B locale(@Nullable Locale locale) {
        this.locales.clear();
        if (locale != null) {
            this.locales.add(locale);
        }
        return this.self();
    }

    public B requestAttr(String name, Object value) {
        AbstractMockHttpServletRequestBuilder.addToMap(this.requestAttributes, name, value);
        return this.self();
    }

    public B sessionAttr(String name, Object value) {
        AbstractMockHttpServletRequestBuilder.addToMap(this.sessionAttributes, name, value);
        return this.self();
    }

    public B sessionAttrs(Map<String, Object> sessionAttributes) {
        Assert.notEmpty(sessionAttributes, (String)"'sessionAttributes' must not be empty");
        sessionAttributes.forEach(this::sessionAttr);
        return this.self();
    }

    public B flashAttr(String name, Object value) {
        AbstractMockHttpServletRequestBuilder.addToMap(this.flashAttributes, name, value);
        return this.self();
    }

    public B flashAttrs(Map<String, Object> flashAttributes) {
        Assert.notEmpty(flashAttributes, (String)"'flashAttributes' must not be empty");
        flashAttributes.forEach(this::flashAttr);
        return this.self();
    }

    public B session(MockHttpSession session) {
        Assert.notNull((Object)session, (String)"'session' must not be null");
        this.session = session;
        return this.self();
    }

    public B principal(Principal principal) {
        Assert.notNull((Object)principal, (String)"'principal' must not be null");
        this.principal = principal;
        return this.self();
    }

    public B remoteAddress(String remoteAddress) {
        Assert.hasText((String)remoteAddress, (String)"'remoteAddress' must not be null or blank");
        this.remoteAddress = remoteAddress;
        return this.self();
    }

    @Override
    public B with(RequestPostProcessor postProcessor) {
        Assert.notNull((Object)postProcessor, (String)"postProcessor is required");
        this.postProcessors.add(postProcessor);
        return this.self();
    }

    public boolean isMergeEnabled() {
        return true;
    }

    public Object merge(@Nullable Object parent) {
        String attributeName;
        String paramName;
        if (parent == null) {
            return this;
        }
        if (!(parent instanceof AbstractMockHttpServletRequestBuilder)) {
            throw new IllegalArgumentException("Cannot merge with [" + parent.getClass().getName() + "]");
        }
        AbstractMockHttpServletRequestBuilder parentBuilder = (AbstractMockHttpServletRequestBuilder)parent;
        if (this.uri == null) {
            this.uri = parentBuilder.uri;
        }
        if (!StringUtils.hasText((String)this.contextPath)) {
            this.contextPath = parentBuilder.contextPath;
        }
        if (!StringUtils.hasText((String)this.servletPath)) {
            this.servletPath = parentBuilder.servletPath;
        }
        if ("".equals(this.pathInfo)) {
            this.pathInfo = parentBuilder.pathInfo;
        }
        if (this.secure == null) {
            this.secure = parentBuilder.secure;
        }
        if (this.principal == null) {
            this.principal = parentBuilder.principal;
        }
        if (this.session == null) {
            this.session = parentBuilder.session;
        }
        if (this.remoteAddress == null) {
            this.remoteAddress = parentBuilder.remoteAddress;
        }
        if (this.characterEncoding == null) {
            this.characterEncoding = parentBuilder.characterEncoding;
        }
        if (this.content == null) {
            this.content = parentBuilder.content;
        }
        if (this.contentType == null) {
            this.contentType = parentBuilder.contentType;
        }
        for (Map.Entry entry : parentBuilder.headers.entrySet()) {
            String headerName = (String)entry.getKey();
            if (this.headers.containsKey((Object)headerName)) continue;
            this.headers.put((Object)headerName, (Object)((List)entry.getValue()));
        }
        for (Map.Entry entry : parentBuilder.parameters.entrySet()) {
            paramName = (String)entry.getKey();
            if (this.parameters.containsKey((Object)paramName)) continue;
            this.parameters.put((Object)paramName, (Object)((List)entry.getValue()));
        }
        for (Map.Entry entry : parentBuilder.queryParams.entrySet()) {
            paramName = (String)entry.getKey();
            if (this.queryParams.containsKey((Object)paramName)) continue;
            this.queryParams.put((Object)paramName, (Object)((List)entry.getValue()));
        }
        for (Map.Entry entry : parentBuilder.formFields.entrySet()) {
            paramName = (String)entry.getKey();
            if (this.formFields.containsKey((Object)paramName)) continue;
            this.formFields.put((Object)paramName, (Object)((List)entry.getValue()));
        }
        for (Cookie cookie : parentBuilder.cookies) {
            if (this.containsCookie(cookie)) continue;
            this.cookies.add(cookie);
        }
        for (Locale locale : parentBuilder.locales) {
            if (this.locales.contains(locale)) continue;
            this.locales.add(locale);
        }
        for (Map.Entry entry : parentBuilder.requestAttributes.entrySet()) {
            attributeName = (String)entry.getKey();
            if (this.requestAttributes.containsKey(attributeName)) continue;
            this.requestAttributes.put(attributeName, entry.getValue());
        }
        for (Map.Entry entry : parentBuilder.sessionAttributes.entrySet()) {
            attributeName = (String)entry.getKey();
            if (this.sessionAttributes.containsKey(attributeName)) continue;
            this.sessionAttributes.put(attributeName, entry.getValue());
        }
        for (Map.Entry entry : parentBuilder.flashAttributes.entrySet()) {
            attributeName = (String)entry.getKey();
            if (this.flashAttributes.containsKey(attributeName)) continue;
            this.flashAttributes.put(attributeName, entry.getValue());
        }
        this.postProcessors.addAll(0, parentBuilder.postProcessors);
        return this;
    }

    private boolean containsCookie(Cookie cookie) {
        for (Cookie cookieToCheck : this.cookies) {
            if (!ObjectUtils.nullSafeEquals((Object)cookieToCheck.getName(), (Object)cookie.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public final MockHttpServletRequest buildRequest(ServletContext servletContext) {
        String requestContentType;
        MediaType mediaType;
        Assert.notNull((Object)this.uri, (String)"'uri' is required");
        MockHttpServletRequest request2 = this.createServletRequest(servletContext);
        request2.setAsyncSupported(true);
        request2.setMethod(this.method.name());
        String requestUri = this.uri.getRawPath();
        request2.setRequestURI(requestUri);
        if (this.uri.getScheme() != null) {
            request2.setScheme(this.uri.getScheme());
        }
        if (this.uri.getHost() != null) {
            request2.setServerName(this.uri.getHost());
        }
        if (this.uri.getPort() != -1) {
            request2.setServerPort(this.uri.getPort());
        }
        this.updatePathRequestProperties(request2, requestUri);
        if (this.secure != null) {
            request2.setSecure(this.secure);
        }
        if (this.principal != null) {
            request2.setUserPrincipal(this.principal);
        }
        if (this.remoteAddress != null) {
            request2.setRemoteAddr(this.remoteAddress);
        }
        if (this.session != null) {
            request2.setSession(this.session);
        }
        request2.setCharacterEncoding(this.characterEncoding);
        request2.setContent(this.content);
        request2.setContentType(this.contentType);
        this.headers.forEach((name, values) -> {
            for (Object value : values) {
                request2.addHeader((String)name, value);
            }
        });
        if (!(ObjectUtils.isEmpty((Object)this.content) || this.headers.containsKey((Object)"Content-Length") || this.headers.containsKey((Object)"Transfer-Encoding"))) {
            request2.addHeader("Content-Length", this.content.length);
        }
        String query = this.uri.getRawQuery();
        if (!this.queryParams.isEmpty()) {
            String str = UriComponentsBuilder.newInstance().queryParams(this.queryParams).build().encode().getQuery();
            String string = query = StringUtils.hasLength((String)query) ? query + "&" + str : str;
        }
        if (query != null) {
            request2.setQueryString(query);
        }
        this.addRequestParams(request2, (MultiValueMap<String, String>)UriComponentsBuilder.fromUri((URI)this.uri).build().getQueryParams());
        this.parameters.forEach((name, values) -> {
            for (String value : values) {
                request2.addParameter((String)name, value);
            }
        });
        if (!this.formFields.isEmpty()) {
            if (this.content != null && this.content.length > 0) {
                throw new IllegalStateException("Could not write form data with an existing body");
            }
            Charset charset = this.characterEncoding != null ? Charset.forName(this.characterEncoding) : StandardCharsets.UTF_8;
            MediaType mediaType2 = mediaType = request2.getContentType() != null ? MediaType.parseMediaType((String)request2.getContentType()) : new MediaType(MediaType.APPLICATION_FORM_URLENCODED, charset);
            if (!mediaType.isCompatibleWith(MediaType.APPLICATION_FORM_URLENCODED)) {
                throw new IllegalStateException("Invalid content type: '" + mediaType + "' is not compatible with '" + MediaType.APPLICATION_FORM_URLENCODED + "'");
            }
            request2.setContent(this.writeFormData(mediaType, charset));
            if (request2.getContentType() == null) {
                request2.setContentType(mediaType.toString());
            }
        }
        if (this.content != null && this.content.length > 0 && (requestContentType = request2.getContentType()) != null) {
            try {
                mediaType = MediaType.parseMediaType((String)requestContentType);
                if (MediaType.APPLICATION_FORM_URLENCODED.includes(mediaType)) {
                    this.addRequestParams(request2, this.parseFormData(mediaType));
                }
            }
            catch (Exception mediaType3) {
                // empty catch block
            }
        }
        if (!ObjectUtils.isEmpty(this.cookies)) {
            request2.setCookies(this.cookies.toArray(new Cookie[0]));
        }
        if (!ObjectUtils.isEmpty(this.locales)) {
            request2.setPreferredLocales(this.locales);
        }
        this.requestAttributes.forEach(request2::setAttribute);
        this.sessionAttributes.forEach((name, attribute) -> {
            HttpSession session = request2.getSession();
            Assert.state((session != null ? 1 : 0) != 0, (String)"No HttpSession");
            session.setAttribute(name, attribute);
        });
        FlashMap flashMap = new FlashMap();
        flashMap.putAll(this.flashAttributes);
        FlashMapManager flashMapManager = this.getFlashMapManager(request2);
        flashMapManager.saveOutputFlashMap(flashMap, (HttpServletRequest)request2, (HttpServletResponse)new MockHttpServletResponse());
        return request2;
    }

    protected MockHttpServletRequest createServletRequest(ServletContext servletContext) {
        return new MockHttpServletRequest(servletContext);
    }

    private void updatePathRequestProperties(MockHttpServletRequest request2, String requestUri) {
        if (!requestUri.startsWith(this.contextPath)) {
            throw new IllegalArgumentException("Request URI [" + requestUri + "] does not start with context path [" + this.contextPath + "]");
        }
        request2.setContextPath(this.contextPath);
        request2.setServletPath(this.servletPath);
        if ("".equals(this.pathInfo)) {
            if (!requestUri.startsWith(this.contextPath + this.servletPath)) {
                throw new IllegalArgumentException("Invalid servlet path [" + this.servletPath + "] for request URI [" + requestUri + "]");
            }
            String extraPath = requestUri.substring(this.contextPath.length() + this.servletPath.length());
            this.pathInfo = StringUtils.hasText((String)extraPath) ? UrlPathHelper.defaultInstance.decodeRequestString((HttpServletRequest)request2, extraPath) : null;
        }
        request2.setPathInfo(this.pathInfo);
    }

    private void addRequestParams(MockHttpServletRequest request2, MultiValueMap<String, String> map) {
        map.forEach((key, values) -> values.forEach(value -> {
            value = value != null ? UriUtils.decode((String)value, (Charset)StandardCharsets.UTF_8) : null;
            request2.addParameter(UriUtils.decode((String)key, (Charset)StandardCharsets.UTF_8), (String)value);
        }));
    }

    private byte[] writeFormData(final MediaType mediaType, Charset charset) {
        final ByteArrayOutputStream out = new ByteArrayOutputStream();
        HttpOutputMessage message = new HttpOutputMessage(){

            public OutputStream getBody() {
                return out;
            }

            public HttpHeaders getHeaders() {
                HttpHeaders headers = new HttpHeaders();
                headers.setContentType(mediaType);
                return headers;
            }
        };
        try {
            FormHttpMessageConverter messageConverter = new FormHttpMessageConverter();
            messageConverter.setCharset(charset);
            messageConverter.write(this.formFields, mediaType, message);
            return out.toByteArray();
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to write form data to request body", ex);
        }
    }

    private MultiValueMap<String, String> parseFormData(final MediaType mediaType) {
        HttpInputMessage message = new HttpInputMessage(){

            public InputStream getBody() {
                byte[] bodyContent = AbstractMockHttpServletRequestBuilder.this.content;
                return bodyContent != null ? new ByteArrayInputStream(bodyContent) : InputStream.nullInputStream();
            }

            public HttpHeaders getHeaders() {
                HttpHeaders headers = new HttpHeaders();
                headers.setContentType(mediaType);
                return headers;
            }
        };
        try {
            return new FormHttpMessageConverter().read(null, message);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to parse form data in request body", ex);
        }
    }

    private FlashMapManager getFlashMapManager(MockHttpServletRequest request2) {
        SessionFlashMapManager flashMapManager = null;
        try {
            ServletContext servletContext = request2.getServletContext();
            WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
            flashMapManager = (FlashMapManager)wac.getBean("flashMapManager", FlashMapManager.class);
        }
        catch (IllegalStateException | NoSuchBeanDefinitionException throwable) {
            // empty catch block
        }
        return flashMapManager != null ? flashMapManager : new SessionFlashMapManager();
    }

    @Override
    public MockHttpServletRequest postProcessRequest(MockHttpServletRequest request2) {
        for (RequestPostProcessor postProcessor : this.postProcessors) {
            request2 = postProcessor.postProcessRequest(request2);
        }
        return request2;
    }

    private static void addToMap(Map<String, Object> map, String name, Object value) {
        Assert.hasLength((String)name, (String)"'name' must not be empty");
        Assert.notNull((Object)value, (String)"'value' must not be null");
        map.put(name, value);
    }

    private static <T> void addToMultiValueMap(MultiValueMap<String, T> map, String name, T[] values) {
        Assert.hasLength((String)name, (String)"'name' must not be empty");
        Assert.notEmpty((Object[])values, (String)"'values' must not be empty");
        for (T value : values) {
            map.add((Object)name, value);
        }
    }
}

