/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactoryInitializer;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.test.context.DynamicPropertySource;

class DynamicPropertySourceBeanInitializer
implements BeanFactoryInitializer<ListableBeanFactory> {
    private static final Log logger = LogFactory.getLog(DynamicPropertySourceBeanInitializer.class);

    DynamicPropertySourceBeanInitializer() {
    }

    public void initialize(ListableBeanFactory beanFactory) {
        for (String name : beanFactory.getBeanNamesForAnnotation(DynamicPropertySource.class)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Eagerly initializing @DynamicPropertySource bean '%s'".formatted(name));
            }
            beanFactory.getBean(name);
        }
    }
}

